/*
 * Decompiled with CFR 0.152.
 */
package com.noisyz.bindlibrary.handler.impl;

import com.noisyz.bindlibrary.annotation.methods.simple.CustomGetter;
import com.noisyz.bindlibrary.handler.AnnotationHandler;
import com.noisyz.bindlibrary.handler.PrimitivesHandler;
import com.noisyz.bindlibrary.models.CustomMethodWrapper;
import com.noisyz.bindlibrary.models.base.MethodItem;
import com.noisyz.bindlibrary.models.key.Key;
import com.noisyz.bindlibrary.models.key.KeyManager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.MirroredTypeException;

public class CustomGetterHandler
extends AnnotationHandler<CustomMethodWrapper, CustomGetter> {
    @Override
    protected CustomMethodWrapper createMethodWrapper(ExecutableElement executableElement, CustomGetter customGetter) {
        try {
            customGetter.value();
        }
        catch (MirroredTypeException e) {
            return new CustomMethodWrapper(e.getTypeMirror().toString());
        }
        return null;
    }

    @Override
    protected MethodItem processAnnotation(ExecutableElement element, CustomGetter customGetter) {
        if (element.getParameters().isEmpty()) {
            String returnType = element.getReturnType().toString();
            String validReturnType = PrimitivesHandler.getReturnTypeOfPrimitiveMethod(returnType);
            return new MethodItem(element.getSimpleName().toString(), validReturnType != null ? validReturnType : returnType);
        }
        return null;
    }

    @Override
    protected Class<CustomGetter> getAnnotation() {
        return CustomGetter.class;
    }

    @Override
    protected AnnotationHandler.Mode getMode() {
        return AnnotationHandler.Mode.GETTER;
    }

    @Override
    protected Key getKey(CustomGetter customGetter, Element element) {
        return KeyManager.getKey(customGetter, element);
    }
}

