/*
 * Decompiled with CFR 0.152.
 */
package com.noisyz.bindlibrary.handler;

import com.noisyz.bindlibrary.models.base.ClassWrapper;
import com.noisyz.bindlibrary.models.base.MethodItem;
import com.noisyz.bindlibrary.models.base.MethodWrapper;
import com.noisyz.bindlibrary.models.key.Key;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;

public abstract class AnnotationHandler<T extends MethodWrapper, A extends Annotation> {
    public void process(ClassWrapper classWrapper, List<ExecutableElement> elements) {
        for (int index = 0; index < elements.size(); ++index) {
            MethodItem methodItem;
            Key key;
            A a;
            ExecutableElement element = elements.get(index);
            if (!element.getModifiers().contains((Object)Modifier.PUBLIC) || (a = element.getAnnotation(this.getAnnotation())) == null || (key = this.getKey(a, element)) == null) continue;
            MethodWrapper methodWrapper = classWrapper.getMethodWrapper(key);
            if (methodWrapper == null) {
                methodWrapper = this.createMethodWrapper(element, a);
            }
            if (methodWrapper == null || (methodItem = this.processAnnotation(element, a)) == null) continue;
            switch (this.getMode()) {
                case GETTER: {
                    methodWrapper.setGetter(methodItem);
                    break;
                }
                case SETTER: {
                    methodWrapper.setSetter(methodItem);
                }
            }
            elements.remove(index);
            --index;
            classWrapper.putMethodWrapper(key, methodWrapper);
        }
    }

    protected abstract T createMethodWrapper(ExecutableElement var1, A var2);

    protected abstract MethodItem processAnnotation(ExecutableElement var1, A var2);

    protected abstract Class<A> getAnnotation();

    protected abstract Mode getMode();

    protected abstract Key getKey(A var1, Element var2);

    public static enum Mode {
        GETTER,
        SETTER;

    }
}

