/*
 * Decompiled with CFR 0.152.
 */
package com.noisyz.bindlibrary.wrappers;

import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import com.noisyz.bindlibrary.base.AbsUIBinder;
import com.noisyz.bindlibrary.models.key.Key;
import com.noisyz.bindlibrary.wrappers.IViewBinder;
import com.noisyz.bindlibrary.wrappers.ValueProvider;
import com.noisyz.bindlibrary.wrappers.ViewBinder;
import java.util.ArrayList;
import java.util.List;

public class PropertyViewWrapper<BO, V extends View, T>
extends AbsUIBinder<BO>
implements ViewBinder.OnViewValueChangedListener<T> {
    private IViewBinder<T, V> iViewBinder;
    private ValueProvider<BO, T> valueProvider;
    private List<V> vList;

    public PropertyViewWrapper(IViewBinder<T, V> iViewBinder, ValueProvider<BO, T> valueProvider, BO bo, Key key) {
        super(bo, key);
        this.iViewBinder = iViewBinder;
        this.valueProvider = valueProvider;
        if (iViewBinder instanceof ViewBinder) {
            ViewBinder viewBinder = (ViewBinder)iViewBinder;
            viewBinder.setOnViewValueChangedListener(this);
        }
    }

    public void registerView(ViewGroup parentView) {
        if (this.vList != null) {
            this.vList.clear();
            this.vList = null;
        }
        if (this.getBinderKey().getKeyResourceId() == 0 && TextUtils.isEmpty((CharSequence)this.getBinderKey().getKeyInString())) {
            return;
        }
        String key = this.getBinderKey().getKeyInString();
        if (TextUtils.isEmpty((CharSequence)key)) {
            key = parentView.getResources().getString(this.getBinderKey().getKeyResourceId());
        }
        this.vList = this.getViewsByTag(parentView, key);
    }

    @Override
    public void onViewValueChanged(T t) {
        this.valueProvider.invokeSetter(this.getBindObject(), t);
    }

    @Override
    public void bindUI() {
        T t = this.valueProvider.invokeGetter(this.getBindObject());
        for (View v : this.vList) {
            ViewBinder viewBinder;
            if (this.iViewBinder instanceof ViewBinder) {
                viewBinder = (ViewBinder)this.iViewBinder;
                viewBinder.removeListeners(v);
            }
            this.iViewBinder.bindUI(t, v);
            if (!(this.iViewBinder instanceof ViewBinder)) continue;
            viewBinder = (ViewBinder)this.iViewBinder;
            viewBinder.addListeners(v);
        }
    }

    public boolean isEmpty() {
        return this.vList == null || this.vList.isEmpty();
    }

    private List<V> getViewsByTag(ViewGroup root, String tag) {
        ArrayList<Object> views = new ArrayList<Object>();
        if (root != null) {
            ViewGroup rootView = root;
            if (this.containsKeyTag(rootView, tag)) {
                views.add(rootView);
            }
            int childCount = root.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View view = root.getChildAt(i);
                if (view instanceof ViewGroup) {
                    views.addAll(this.getViewsByTag((ViewGroup)view, tag));
                    continue;
                }
                try {
                    View child = view;
                    if (!this.containsKeyTag(child, tag)) continue;
                    views.add(child);
                    continue;
                }
                catch (ClassCastException e) {
                    e.printStackTrace();
                }
            }
        }
        return views;
    }

    private boolean containsKeyTag(V child, String tag) {
        Object object = child.getTag();
        if (object != null) {
            String[] tagsObj;
            String objectTagInString = object.toString();
            for (String tagObj : tagsObj = objectTagInString.split("\\|")) {
                boolean isField = tagObj.equals(tag);
                if (TextUtils.isEmpty((CharSequence)tagObj) || !isField) continue;
                String newTag = "";
                for (int j = 0; j < tagsObj.length; ++j) {
                    if (tagsObj[j].equals(tagObj)) continue;
                    newTag = newTag + tagsObj[j];
                    if (j >= tagsObj.length - 1) continue;
                    newTag = newTag + "|";
                }
                if (TextUtils.isEmpty((CharSequence)newTag)) {
                    child.setTag(null);
                } else {
                    child.setTag((Object)newTag);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void release() {
        super.release();
        if (this.vList != null) {
            this.vList.clear();
            this.vList = null;
        }
        if (this.iViewBinder != null && this.iViewBinder instanceof ViewBinder) {
            ((ViewBinder)this.iViewBinder).release();
            this.iViewBinder = null;
        }
        if (this.valueProvider != null) {
            this.valueProvider = null;
        }
    }
}

