package com.noisyz.bindlibrary.property;

import android.view.View;

import com.noisyz.bindlibrary.annotation.Type;
import com.noisyz.bindlibrary.models.key.Key;
import com.noisyz.bindlibrary.property.abs.Property;
import com.noisyz.bindlibrary.wrappers.IViewBinder;
import com.noisyz.bindlibrary.wrappers.PropertyViewWrapper;
import com.noisyz.bindlibrary.wrappers.ValueProvider;
import com.noisyz.bindlibrary.wrappers.view.color.CardBackgroundColorViewWrapper;
import com.noisyz.bindlibrary.wrappers.view.color.ColorViewWrapper;
import com.noisyz.bindlibrary.wrappers.view.color.TextColorViewWrapper;
import com.noisyz.bindlibrary.wrappers.view.color.resource.CardBackgroundResourceColorViewWrapper;
import com.noisyz.bindlibrary.wrappers.view.color.resource.ColorResourceViewWrapper;
import com.noisyz.bindlibrary.wrappers.view.color.resource.TextColorResourceViewBinder;
import com.noisyz.bindlibrary.wrappers.view.simple.BooleanWrapper;
import com.noisyz.bindlibrary.wrappers.view.simple.ChangeableRatingBarWrapper;
import com.noisyz.bindlibrary.wrappers.view.simple.EnabledWrapper;
import com.noisyz.bindlibrary.wrappers.view.simple.ProgressViewWrapper;
import com.noisyz.bindlibrary.wrappers.view.simple.RatingBarWrapper;
import com.noisyz.bindlibrary.wrappers.view.simple.ReverseBooleanWrapper;
import com.noisyz.bindlibrary.wrappers.view.simple.SeekBarWrapper;
import com.noisyz.bindlibrary.wrappers.view.simple.VisibilityWrapper;
import com.noisyz.bindlibrary.wrappers.view.simple.text.DoubleTextWrapper;
import com.noisyz.bindlibrary.wrappers.view.simple.text.FloatTextWrapper;
import com.noisyz.bindlibrary.wrappers.view.simple.text.FormattedTextViewWrapper;
import com.noisyz.bindlibrary.wrappers.view.simple.text.IntegerTextWrapper;
import com.noisyz.bindlibrary.wrappers.view.simple.text.ResourceTextViewWrapper;
import com.noisyz.bindlibrary.wrappers.view.simple.text.TextViewWrapper;

/**
 * Created by nero232 on 15.04.17.
 */

public class DefaultProperty<BO, V extends View, T> extends Property<BO, T> {

    private Type type;

    public DefaultProperty(Type type, ValueProvider<BO, T> valueProvider, Key key) {
        super(valueProvider, key);
        this.type = type;
    }

    @Override
    public PropertyViewWrapper<BO, V, T> buildPropertyViewWrapper(BO bo) {
        IViewBinder<T, V> viewBinder = getViewBinder();
        if (viewBinder != null)
            return new PropertyViewWrapper<>(viewBinder, getValueProvider(), bo, getKey());
        return null;
    }

    private IViewBinder<T, V> getViewBinder() {
        IViewBinder viewWrapper = null;
        try {
            switch (type) {
                case BOOLEAN:
                    if (getKey().toString().startsWith("!"))
                        viewWrapper = new ReverseBooleanWrapper();
                    else
                        viewWrapper = new BooleanWrapper();
                    break;
                case TEXT:
                    viewWrapper = new TextViewWrapper();
                    break;
                case TEXT_RESOURCE:
                    viewWrapper = new ResourceTextViewWrapper();
                    break;
                case FORMATTED_TEXT:
                    viewWrapper = new FormattedTextViewWrapper();
                    break;
                case INTEGER_TEXT:
                    viewWrapper = new IntegerTextWrapper();
                    break;
                case DOUBLE_TEXT:
                    viewWrapper = new DoubleTextWrapper();
                    break;
                case FLOAT_TEXT:
                    viewWrapper = new FloatTextWrapper();
                    break;
                case PROGRESS:
                    viewWrapper = new ProgressViewWrapper();
                    break;
                case PROGRESS_CHANGEABLE:
                    viewWrapper = new SeekBarWrapper();
                    break;
                case RATING:
                    viewWrapper = new RatingBarWrapper();
                    break;
                case RATING_CHANGEABLE:
                    viewWrapper = new ChangeableRatingBarWrapper();
                    break;
                case VISIBILITY:
                    viewWrapper = new VisibilityWrapper();
                    break;
                case ENABLED:
                    viewWrapper = new EnabledWrapper();
                    break;
                case COLOR:
                    viewWrapper = new ColorViewWrapper();
                    break;
                case TEXT_COLOR:
                    viewWrapper = new TextColorViewWrapper();
                    break;
                case CARD_COLOR:
                    viewWrapper = new CardBackgroundColorViewWrapper();
                    break;
                case COLOR_RESOURCE:
                    viewWrapper = new ColorResourceViewWrapper();
                    break;
                case TEXT_COLOR_RESOURCE:
                    viewWrapper = new TextColorResourceViewBinder();
                    break;
                case CARD_COLOR_RESOURCE:
                    viewWrapper = new CardBackgroundResourceColorViewWrapper();
                    break;
            }
        } catch (ClassCastException e) {
            e.printStackTrace();
            return null;
        }
        return viewWrapper;
    }
}
