/*
 * Decompiled with CFR 0.152.
 */
package com.noisyz.bindlibrary.base.impl.adapter;

import com.noisyz.bindlibrary.base.impl.adapter.RecyclerBindAdapter;
import com.noisyz.bindlibrary.callback.filter.ItemFilterCallback;
import com.noisyz.bindlibrary.callback.filter.ItemsFilter;
import com.noisyz.bindlibrary.callback.layoutcallback.LayoutResourceProvider;
import java.util.ArrayList;
import java.util.List;

public abstract class RecyclerFilterableBindAdapter<T, V>
extends RecyclerBindAdapter<T>
implements ItemsFilter<V> {
    private List<T> filteredList;
    private ItemFilterCallback<T, V> itemFilterCallback;

    public RecyclerFilterableBindAdapter(List<T> itemList, int layoutResID, ItemFilterCallback<T, V> itemFilterCallback) {
        super(itemList, layoutResID);
        this.itemFilterCallback = itemFilterCallback;
    }

    public RecyclerFilterableBindAdapter(List<T> itemList, LayoutResourceProvider<T> mLayoutResourceProvider, ItemFilterCallback<T, V> itemFilterCallback) {
        super(itemList, mLayoutResourceProvider);
        this.itemFilterCallback = itemFilterCallback;
    }

    @Override
    public int getItemCount() {
        List<T> list = this.itemFilterCallback != null ? this.filteredList : this.getItems();
        return list != null ? list.size() : 0;
    }

    @Override
    public T getItem(int position) {
        List<T> list = this.itemFilterCallback != null ? this.filteredList : this.getItems();
        return list != null ? (T)list.get(position) : null;
    }

    @Override
    public void filter(V v) {
        if (this.itemFilterCallback != null) {
            this.filteredList = new ArrayList<T>();
            for (Object t : this.getItems()) {
                if (!this.itemFilterCallback.filterBy(t, v)) continue;
                this.filteredList.add(t);
            }
            this.notifyDataSetChanged();
        }
    }
}

