/*
 * Decompiled with CFR 0.152.
 */
package com.noisyz.bindlibrary.classbuilder;

import com.noisyz.bindlibrary.StringUtils;
import com.noisyz.bindlibrary.classbuilder.base.Class;
import com.noisyz.bindlibrary.classbuilder.base.Field;
import com.noisyz.bindlibrary.classbuilder.base.Method;
import com.noisyz.bindlibrary.models.base.MethodWrapper;

public class ValueProviderPattern
extends Class {
    private String parentClass;
    private String propertyKey;
    private MethodWrapper methodWrapper;

    public ValueProviderPattern(String parentClass, String propertyKey, MethodWrapper methodWrapper) {
        this.parentClass = parentClass;
        this.propertyKey = propertyKey;
        this.methodWrapper = methodWrapper;
        this.addImport(parentClass);
        this.addImport(methodWrapper.getType());
        this.addImport("com.noisyz.bindlibrary.wrappers.ValueProvider");
        this.setup();
    }

    private void setup() {
        String bindObjectName = StringUtils.getShortType(this.parentClass);
        String valueProviderPackage = "com.bindlibrary.generated." + bindObjectName.toLowerCase() + ".valueprovider";
        this.setPackageName(valueProviderPackage);
        String valueProviderClassName = bindObjectName + StringUtils.makeFirstCharUpperCase(this.propertyKey) + "ValueProvider";
        this.setName(valueProviderClassName);
        this.addImplementation("ValueProvider<" + bindObjectName + ", " + this.getType() + ">");
        this.addMethod(this.getGetter(bindObjectName));
        this.addMethod(this.getSetter(bindObjectName));
    }

    private String getType() {
        return StringUtils.getShortType(this.methodWrapper.getType());
    }

    private String getParentVariable() {
        return StringUtils.getTypeAsVariable(this.parentClass);
    }

    private Method getGetter(String parentName) {
        return new Method().setName("invokeGetter").addArgument(new Field().setTypeAndName(parentName, StringUtils.getTypeAsVariable(parentName))).setReturnType(this.getType()).addBody(" return " + this.getParentVariable() + "." + this.methodWrapper.getGetter().toString() + "()");
    }

    private Method getSetter(String parentName) {
        Method setter = new Method().setName("invokeSetter").addArgument(new Field().setTypeAndName(parentName, StringUtils.getTypeAsVariable(parentName))).addArgument(new Field().setTypeAndName(this.getType(), StringUtils.getTypeAsVariable(this.getType())));
        if (this.methodWrapper.getSetter() != null) {
            setter.addBody(this.getParentVariable() + "." + this.methodWrapper.getSetter().toString() + "(" + StringUtils.getTypeAsVariable(this.getType()) + ")");
        }
        return setter;
    }
}

