/*
 * Decompiled with CFR 0.152.
 */
package com.noisyz.bindlibrary.classbuilder;

import com.noisyz.bindlibrary.StringUtils;
import com.noisyz.bindlibrary.classbuilder.base.Class;
import com.noisyz.bindlibrary.classbuilder.base.Constructor;
import com.noisyz.bindlibrary.classbuilder.base.Field;
import com.noisyz.bindlibrary.classbuilder.base.Method;

public class RecyclerBindAdapterPattern
extends Class {
    public RecyclerBindAdapterPattern(String type) {
        this.addImport(type);
        this.importParentClass();
        this.addImport("com.noisyz.bindlibrary.base.impl.ObjectViewBinder");
        this.addImport("com.noisyz.bindlibrary.callback.layoutcallback.LayoutResourceProvider");
        this.addImport("java.util.List");
        String shortType = StringUtils.getShortType(type);
        this.setup(shortType);
    }

    private void setup(String shortType) {
        this.addImport("com.bindlibrary.generated." + shortType + "ViewBinder");
        this.setPackageName("com.bindlibrary.generated." + shortType.toLowerCase() + ".adapter");
        this.setName(this.getName(shortType));
        this.setSuperClass(this.getParentClass(shortType));
        this.initConstructors(shortType);
        this.initMethods(shortType);
    }

    protected String getName(String shortType) {
        return shortType + "BindAdapter";
    }

    protected String getParentClass(String shortType) {
        return "RecyclerBindAdapter<" + shortType + ">";
    }

    protected void importParentClass() {
        this.addImport("com.noisyz.bindlibrary.base.impl.adapter.RecyclerBindAdapter");
    }

    private void initConstructors(String type) {
        this.addConstructor(this.buildBaseConstructor(type));
        this.addConstructor(this.buildMultiTypeConstructor(type));
    }

    protected Constructor buildMultiTypeConstructor(String type) {
        Constructor multiTypeConstructor = this.buildEmptyConstructor(type);
        multiTypeConstructor.addArgument(new Field().setTypeAndName("LayoutResourceProvider<" + type + ">", "layoutProvider")).addBody("super(itemList, layoutProvider)");
        return multiTypeConstructor;
    }

    protected Constructor buildBaseConstructor(String type) {
        Constructor baseConstructor = this.buildEmptyConstructor(type);
        baseConstructor.addArgument(new Field().setTypeAndName("int", "layoutResID")).addBody("super(itemList, layoutResID)");
        return baseConstructor;
    }

    private void initMethods(String type) {
        Method method = new Method().setReturnType("ObjectViewBinder<" + type + ">").setModifiers("protected").setName("initObjectViewBinder").addArgument(new Field().setTypeAndName(type, StringUtils.getTypeAsVariable(type))).addBody("return new " + type + "ViewBinder(" + StringUtils.getTypeAsVariable(type) + ")");
        this.addMethod(method);
    }

    public Constructor buildEmptyConstructor(String type) {
        Constructor constructor = this.buildEmptyConstructor();
        constructor.addArgument(new Field().setTypeAndName("List<" + type + ">", "itemList"));
        return constructor;
    }
}

