/*
 * Decompiled with CFR 0.152.
 */
package com.noisyz.bindlibrary.classbuilder.base;

import com.noisyz.bindlibrary.classbuilder.base.Field;
import java.util.ArrayList;
import java.util.List;

public class Method {
    private String returnType = "void";
    private String modifiers = "public";
    private String name;
    private List<String> bodyLines = new ArrayList<String>();
    private List<Field> args = new ArrayList<Field>();

    public Method setName(String name) {
        this.name = name;
        return this;
    }

    public Method setReturnType(String returnType) {
        this.returnType = returnType;
        return this;
    }

    public Method setModifiers(String modifiers) {
        this.modifiers = modifiers;
        return this;
    }

    public Method addArgument(Field field) {
        this.args.add(field);
        return this;
    }

    public Method addBody(String bodyPart) {
        this.bodyLines.add(bodyPart);
        return this;
    }

    public String toString() {
        StringBuilder method = new StringBuilder();
        this.fillSignature(method);
        this.fillMethodBody(method);
        return method.toString();
    }

    private void fillSignature(StringBuilder method) {
        method.append("\t").append(this.modifiers);
        if (this.returnType != null) {
            method.append(" ").append(this.returnType);
        }
        if (this.name != null) {
            method.append(" ").append(this.name);
        }
        method.append("(");
        this.fillVariables(method);
        method.append("){\n");
    }

    private void fillVariables(StringBuilder method) {
        for (int index = 0; index < this.args.size(); ++index) {
            Field argument = this.args.get(index);
            method.append(argument.toString());
            if (index >= this.args.size() - 1) continue;
            method.append(", ");
        }
    }

    private void fillMethodBody(StringBuilder method) {
        for (String line : this.bodyLines) {
            method.append("\t\t").append(line).append(";\n");
        }
        method.append("\t}");
    }
}

