/*
 * Decompiled with CFR 0.152.
 */
package com.noisyz.bindlibrary.classbuilder.base;

import com.noisyz.bindlibrary.Environment;
import com.noisyz.bindlibrary.classbuilder.base.Constructor;
import com.noisyz.bindlibrary.classbuilder.base.Field;
import com.noisyz.bindlibrary.classbuilder.base.Method;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;

public class Class {
    private String name;
    private String packageName;
    private String superClass;
    private String modifiers = "public";
    private List<String> imports = new ArrayList<String>();
    private List<String> staticInitializer = new ArrayList<String>();
    private List<String> implementedInterfaces = new ArrayList<String>();
    private List<Method> methods = new ArrayList<Method>();
    private List<Field> fields = new ArrayList<Field>();
    private List<Constructor> constructors = new ArrayList<Constructor>();

    public Class setName(String name) {
        this.name = name;
        return this;
    }

    public Class setPackageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public Class setSuperClass(String superClass) {
        this.superClass = superClass;
        return this;
    }

    public Class setModifiers(String modifiers) {
        this.modifiers = modifiers;
        return this;
    }

    public Class addImport(String className) {
        int alreadyImported = 0;
        for (String imported : this.imports) {
            if (!imported.equals(className)) continue;
            ++alreadyImported;
        }
        if (alreadyImported == 0) {
            this.imports.add(className);
        }
        return this;
    }

    public Class addImplementation(String implementation) {
        this.implementedInterfaces.add(implementation);
        return this;
    }

    public Class addMethod(Method method) {
        this.methods.add(method);
        return this;
    }

    public Class addField(Field field) {
        this.fields.add(field);
        return this;
    }

    public Class addStaticInitializerLine(String line) {
        this.staticInitializer.add(line);
        return this;
    }

    public Class addConstructor(Constructor constructor) {
        this.constructors.add(constructor);
        return this;
    }

    public Constructor buildEmptyConstructor() {
        return new Constructor().setType(this.name);
    }

    public String toString() {
        StringBuilder classBody = new StringBuilder();
        this.fillClassHeader(classBody);
        this.fillSignature(classBody);
        this.fillClassData(classBody);
        return classBody.toString();
    }

    private void fillClassHeader(StringBuilder classBody) {
        classBody.append("package ").append(this.packageName).append(";\n\n");
        for (String importClass : this.imports) {
            classBody.append("import ").append(importClass).append(";\n");
        }
        classBody.append("\n");
    }

    private void fillSignature(StringBuilder classBody) {
        classBody.append(this.modifiers).append(" class ").append(this.name);
        if (this.superClass != null) {
            classBody.append(" ").append("extends ").append(this.superClass);
        }
        if (!this.implementedInterfaces.isEmpty()) {
            classBody.append(" implements ");
            for (int index = 0; index < this.implementedInterfaces.size(); ++index) {
                String implementation = this.implementedInterfaces.get(index);
                classBody.append(implementation);
                if (index >= this.implementedInterfaces.size() - 1) continue;
                classBody.append(", ");
            }
        }
        classBody.append("{\n\n");
    }

    private void fillClassData(StringBuilder classBody) {
        if (!this.fields.isEmpty()) {
            for (Field field : this.fields) {
                classBody.append("\t").append(field.toString()).append(";\n");
            }
            classBody.append("\n");
        }
        if (!this.staticInitializer.isEmpty()) {
            classBody.append("\tstatic{\n");
            for (String line : this.staticInitializer) {
                classBody.append("\t\t").append(line).append(";\n");
            }
            classBody.append("\t}\n\n");
        }
        if (!this.constructors.isEmpty()) {
            for (Constructor constructor : this.constructors) {
                classBody.append(constructor.toString()).append("\n\n");
            }
        }
        for (Method method : this.methods) {
            classBody.append(method.toString()).append("\n\n");
        }
        classBody.append("}");
    }

    public String writeSource() {
        try {
            String sourceName = this.packageName + "." + this.name;
            JavaFileObject source = Environment.getInstance().getFiler().createSourceFile(sourceName, new Element[0]);
            Writer writer = source.openWriter();
            writer.write(this.toString());
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.packageName + "." + this.name;
    }
}

