/*
 * Decompiled with CFR 0.152.
 */
package com.noisyz.bindlibrary.classbuilder;

import com.noisyz.bindlibrary.StringUtils;
import com.noisyz.bindlibrary.classbuilder.base.Class;
import com.noisyz.bindlibrary.classbuilder.base.Constructor;
import com.noisyz.bindlibrary.classbuilder.base.Field;
import com.noisyz.bindlibrary.classbuilder.base.Method;

public class RecyclerBindAdapterPattern
extends Class {
    public RecyclerBindAdapterPattern(String type) {
        this.addImport(type);
        this.addImport("com.noisyz.bindlibrary.base.impl.adapter.RecyclerBindAdapter");
        this.addImport("com.noisyz.bindlibrary.base.impl.ObjectViewBinder");
        this.addImport("com.noisyz.bindlibrary.callback.layoutcallback.LayoutResourceProvider");
        this.addImport("java.util.List");
        String shortType = StringUtils.getShortType(type);
        this.setup(shortType);
    }

    private void setup(String shortType) {
        this.addImport("com.bindlibrary.generated." + shortType + "ViewBinder");
        this.setPackageName("com.bindlibrary.generated." + shortType.toLowerCase() + ".adapter");
        this.setName(shortType + "BindAdapter");
        this.setSuperClass("RecyclerBindAdapter<" + shortType + ">");
        this.initConstructors(shortType);
        this.initMethods(shortType);
    }

    private void initConstructors(String type) {
        Constructor baseConstructor = this.buildEmptyConstructor(type);
        baseConstructor.addArgument(new Field().setTypeAndName("int", "layoutResID")).addBody("super(itemList, layoutResID)");
        this.addConstructor(baseConstructor);
        Constructor multiTypeConstructor = this.buildEmptyConstructor(type);
        multiTypeConstructor.addArgument(new Field().setTypeAndName("LayoutResourceProvider<" + type + ">", "layoutProvider")).addBody("super(itemList, layoutProvider)");
        this.addConstructor(multiTypeConstructor);
    }

    private void initMethods(String type) {
        Method method = new Method().setReturnType("ObjectViewBinder<" + type + ">").setModifiers("protected").setName("initObjectViewBinder").addArgument(new Field().setTypeAndName(type, StringUtils.getTypeAsVariable(type))).addBody("return new " + type + "ViewBinder(" + StringUtils.getTypeAsVariable(type) + ")");
        this.addMethod(method);
    }

    public Constructor buildEmptyConstructor(String type) {
        Constructor constructor = this.buildEmptyConstructor();
        constructor.addArgument(new Field().setTypeAndName("List<" + type + ">", "itemList"));
        return constructor;
    }
}

