/*
 * Decompiled with CFR 0.152.
 */
package com.noisyz.bindlibrary.handler;

import com.noisyz.bindlibrary.Environment;
import com.noisyz.bindlibrary.annotation.Bind;
import com.noisyz.bindlibrary.handler.AnnotationHandler;
import com.noisyz.bindlibrary.handler.PrimitivesHandler;
import com.noisyz.bindlibrary.models.base.ClassWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public class BindClassesHandler {
    private final List<AnnotationHandler> handlers;
    private final Set<? extends Element> elements;

    public BindClassesHandler(Set<? extends Element> elements) {
        this.elements = elements;
        this.handlers = new ArrayList<AnnotationHandler>();
    }

    public BindClassesHandler addHandler(AnnotationHandler annotationHandler) {
        this.handlers.add(annotationHandler);
        return this;
    }

    public Map<String, ClassWrapper> processAndBuild() {
        HashMap<String, ClassWrapper> classWrapperMap = new HashMap<String, ClassWrapper>();
        for (Element element : this.elements) {
            TypeMirror typeMirror;
            Element element2;
            Bind bind = element.getAnnotation(Bind.class);
            TypeElement typeElement = (TypeElement)element;
            String name = Environment.getInstance().getElementUtils().getBinaryName(typeElement).toString();
            boolean generateAdapters = bind.generateAdapters();
            boolean filterable = bind.filterable();
            ClassWrapper classWrapper = new ClassWrapper(generateAdapters, filterable);
            do {
                List<ExecutableElement> elements = this.getMethodsFromClass(typeElement);
                for (AnnotationHandler handler : this.handlers) {
                    handler.process(classWrapper, elements);
                }
                new PrimitivesHandler().processPrimitives(classWrapper, elements);
                typeMirror = typeElement.getSuperclass();
            } while (!(typeElement = (TypeElement)(element2 = Environment.getInstance().getTypeUtils().asElement(typeMirror))).toString().equals("java.lang.Object"));
            classWrapperMap.put(name, classWrapper);
        }
        return classWrapperMap;
    }

    private List<? extends ExecutableElement> getMethodsFromClass(TypeElement classElement) {
        List<? extends Element> elements = classElement.getEnclosedElements();
        return ElementFilter.methodsIn(elements);
    }
}

