package com.noisyz.bindlibrary.base.impl.adapter;

import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.noisyz.bindlibrary.base.impl.ObjectViewBinder;
import com.noisyz.bindlibrary.callback.clickevent.OnElementClickListener;
import com.noisyz.bindlibrary.callback.clickevent.OnElementClickListenerWrapper;
import com.noisyz.bindlibrary.callback.clickevent.OnItemClickListener;
import com.noisyz.bindlibrary.callback.filter.ItemFilterCallback;
import com.noisyz.bindlibrary.callback.filter.ItemsFilter;
import com.noisyz.bindlibrary.callback.layoutcallback.EmptyBaseLayoutResourceProvider;
import com.noisyz.bindlibrary.callback.layoutcallback.LayoutResourceProvider;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by oleg on 06.09.16.
 */
public abstract class RecyclerFilterableBindAdapter<T, V> extends RecyclerBindAdapter<T> implements ItemsFilter<V> {

    private List<T> filteredList;
    private ItemFilterCallback<T, V> itemFilterCallback;

    public RecyclerFilterableBindAdapter(List<T> itemList, int layoutResID,
                                         ItemFilterCallback<T, V> itemFilterCallback) {
        super(itemList, layoutResID);
        this.itemFilterCallback = itemFilterCallback;
    }

    public RecyclerFilterableBindAdapter(List<T> itemList, LayoutResourceProvider<T> mLayoutResourceProvider,
                                         ItemFilterCallback<T, V> itemFilterCallback) {
        super(itemList, mLayoutResourceProvider);
        this.itemFilterCallback = itemFilterCallback;
    }

    @Override
    public int getItemCount() {
        List<T> list = itemFilterCallback != null ? filteredList : getItems();
        return list != null ? list.size() : 0;
    }

    public T getItem(int position) {
        List<T> list = itemFilterCallback != null ? filteredList : getItems();
        return list != null ? list.get(position) : null;
    }

    @Override
    public void filter(V v) {
        if (itemFilterCallback != null) {
            filteredList = new ArrayList<>();
            for (T t : getItems()) {
                if (itemFilterCallback.filterBy(t, v))
                    filteredList.add(t);
            }
            notifyDataSetChanged();
        }
    }
}
