/*
 * Decompiled with CFR 0.152.
 */
package com.noisyz.bindlibrary.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectionUtils {
    public static Object getClassInstance(Class<?> clazz, Object ... params) {
        Object object = null;
        try {
            Class[] classArr = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                classArr[i] = params[i].getClass();
            }
            Constructor<?> constructor = clazz.getConstructor(classArr);
            object = constructor.newInstance(params);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return object;
    }

    public static void invokeSetterMethod(Method method, Object object, Object value) throws InvocationTargetException, IllegalAccessException {
        method.setAccessible(true);
        if (method.isAccessible()) {
            method.invoke(object, value);
        }
    }

    public static Object invokeGetterMethod(Method method, Object object) {
        Object result = null;
        try {
            method.setAccessible(true);
            if (method.isAccessible()) {
                result = method.invoke(object, new Object[0]);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Object getVariableValue(Field f, Object object) {
        Object result = null;
        try {
            f.setAccessible(true);
            if (f.isAccessible()) {
                result = f.get(object);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void setVariableValue(Field f, Object parentObject, Object value) throws IllegalAccessException {
        f.set(parentObject, value);
    }
}

