/*
 * Decompiled with CFR 0.152.
 */
package com.noisyz.bindlibrary.base.impl;

import android.app.Activity;
import android.view.View;
import android.view.ViewGroup;
import com.noisyz.bindlibrary.base.AbsUIBinder;
import com.noisyz.bindlibrary.base.TreeUIBinder;
import com.noisyz.bindlibrary.wrappers.impl.obj.PropertyFactory;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;

public class ObjectViewBinder
extends TreeUIBinder
implements View.OnAttachStateChangeListener {
    private WeakReference<View> parentViewRef;

    public ObjectViewBinder(Object object) {
        super(object);
    }

    public ObjectViewBinder registerView(Activity activity) {
        View viewGroup = ((ViewGroup)activity.findViewById(0x1020002)).getChildAt(0);
        return this.registerView(viewGroup);
    }

    public ObjectViewBinder registerView(View parentView) {
        this.parentViewRef = new WeakReference<View>(parentView);
        Object object = this.getObject();
        if (object != null) {
            List<AbsUIBinder> binders = PropertyFactory.getPropertyList(this, object, parentView);
            binders.removeAll(Collections.singleton(null));
            this.addChildren(binders);
        }
        return this;
    }

    public View getViewParent() {
        return (View)this.parentViewRef.get();
    }

    public ObjectViewBinder setOnElementClick(int elementId, View.OnClickListener onClickListener) {
        View child;
        View parentView = this.getViewParent();
        if (parentView != null && (child = parentView.findViewById(elementId)) != null) {
            child.setOnClickListener(onClickListener);
        }
        return this;
    }

    public ObjectViewBinder setOnElementsClick(View.OnClickListener onClickListener, int ... elementsId) {
        for (int elementId : elementsId) {
            this.setOnElementClick(elementId, onClickListener);
        }
        return this;
    }

    @Override
    public void release() {
        super.release();
        this.parentViewRef.clear();
        this.parentViewRef = null;
    }

    public void onViewAttachedToWindow(View view) {
    }

    public void onViewDetachedFromWindow(View view) {
        this.release();
    }
}

