/*
 * Decompiled with CFR 0.152.
 */
package com.noisyz.bindlibrary.wrappers.impl.obj;

import android.view.View;
import com.noisyz.bindlibrary.base.AbsUIBinder;
import com.noisyz.bindlibrary.conversion.Converter;
import com.noisyz.bindlibrary.conversion.EmptyConverter;
import com.noisyz.bindlibrary.wrappers.impl.obj.IViewBinder;
import com.noisyz.bindlibrary.wrappers.impl.obj.ViewBinder;
import java.lang.ref.WeakReference;

public abstract class PropertyViewWrapper<VB extends IViewBinder>
extends AbsUIBinder
implements ViewBinder.OnViewValueChangedListener {
    private Converter updateUIConverter = new EmptyConverter();
    private Converter updateObjectValueConverter = new EmptyConverter();
    private VB vb;
    private WeakReference<View> view;

    public PropertyViewWrapper(VB vb, View view, Object object, String propertyName) {
        super(object, propertyName);
        this.vb = vb;
        this.view = new WeakReference<View>(view);
        if (vb instanceof ViewBinder) {
            ViewBinder viewBinder = (ViewBinder)vb;
            viewBinder.addListeners(view);
            viewBinder.setOnViewValueChangedListener(this);
        }
    }

    @Override
    public void bindUI() {
        Object value = this.getUIBindValue();
        View view = (View)this.view.get();
        if (view != null && value != null) {
            if (this.vb instanceof ViewBinder) {
                ((ViewBinder)this.vb).removeListeners(view);
                this.vb.bindUI((Object)value, (View)view);
                ((ViewBinder)this.vb).addListeners(view);
            } else {
                this.vb.bindUI((Object)value, (View)view);
            }
        }
    }

    @Override
    public void onViewValueChanged() {
        if (this.vb instanceof ViewBinder) {
            ViewBinder viewBinder = (ViewBinder)this.vb;
            View view = (View)this.view.get();
            if (view != null) {
                this.bindObject(viewBinder.getViewValue(view));
            }
        }
    }

    public void bindObject(Object value) {
        if (value != null) {
            Object convertedValue = this.getUpdateObjectValueConverter().getConvertedValue(value);
            this.updateObjectByValue(convertedValue);
        }
    }

    protected Object getUIBindValue() {
        return this.getUpdateUIConverter().getConvertedValue(this.getUIBindPropertyValue());
    }

    protected abstract Object getUIBindPropertyValue();

    protected abstract void updateObjectByValue(Object var1);

    public void setUpdateUIConverter(Converter converter) {
        this.updateUIConverter = converter;
    }

    public void setUpdateObjectConverter(Converter converter) {
        this.updateObjectValueConverter = converter;
    }

    public Converter getUpdateUIConverter() {
        return this.updateUIConverter;
    }

    public Converter getUpdateObjectValueConverter() {
        return this.updateObjectValueConverter;
    }

    @Override
    public void release() {
        super.release();
        if (this.vb instanceof ViewBinder) {
            View view = (View)this.view.get();
            if (view != null) {
                ((ViewBinder)this.vb).removeListeners(view);
            }
            ((ViewBinder)this.vb).release();
        }
        this.vb = null;
        this.updateObjectValueConverter = null;
        this.updateUIConverter = null;
    }
}

