/*
 * Decompiled with CFR 0.152.
 */
package com.noisyz.bindlibrary.wrappers;

import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ImageView;
import com.noisyz.bindlibrary.annotations.field.collection.AdapterViewField;
import com.noisyz.bindlibrary.annotations.field.simple.CustomField;
import com.noisyz.bindlibrary.annotations.field.simple.ImageField;
import com.noisyz.bindlibrary.annotations.field.simple.ObjectField;
import com.noisyz.bindlibrary.annotations.methods.collection.SimpleAdapterViewGetter;
import com.noisyz.bindlibrary.annotations.methods.collection.SimpleAdapterViewSetter;
import com.noisyz.bindlibrary.annotations.methods.simple.CustomGetterMethod;
import com.noisyz.bindlibrary.annotations.methods.simple.CustomSetterMethod;
import com.noisyz.bindlibrary.annotations.methods.simple.GetterMethod;
import com.noisyz.bindlibrary.annotations.methods.simple.ImageGetterMethod;
import com.noisyz.bindlibrary.annotations.methods.simple.ObjectGetterMethod;
import com.noisyz.bindlibrary.annotations.methods.simple.SetterMethod;
import com.noisyz.bindlibrary.base.AbsUIBinder;
import com.noisyz.bindlibrary.base.ParentBinder;
import com.noisyz.bindlibrary.base.TreeUIBinder;
import com.noisyz.bindlibrary.base.impl.ObjectViewBinder;
import com.noisyz.bindlibrary.utils.ReflectionUtils;
import com.noisyz.bindlibrary.wrappers.PropertyViewWrapper;
import com.noisyz.bindlibrary.wrappers.WrapperViewFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class PropertyFactory {
    public static List<AbsUIBinder> getPropertyList(ParentBinder parentBinder, Object object, View parentView) {
        ArrayList<AbsUIBinder> properties = new ArrayList<AbsUIBinder>();
        if (object != null && parentView != null) {
            properties.addAll(PropertyFactory.getFieldPropertyList(parentBinder, object, parentView));
            properties.addAll(PropertyFactory.getMethodPropertyList(parentBinder, object, parentView));
        }
        return properties;
    }

    private static List<AbsUIBinder> getFieldPropertyList(ParentBinder parentBinder, Object object, View parentView) {
        ArrayList<AbsUIBinder> fieldList = new ArrayList<AbsUIBinder>();
        for (Field field : object.getClass().getDeclaredFields()) {
            ArrayList<View> views = PropertyFactory.getViewsByTag((ViewGroup)parentView, field.getName());
            ArrayList<AbsUIBinder> properties = new ArrayList<AbsUIBinder>();
            for (View view : views) {
                AbsUIBinder absUIBinder = PropertyFactory.getFieldViewWrapper(field, view, object);
                PropertyFactory.updateDataCallbackByParent(parentBinder, properties, absUIBinder);
            }
            AbsUIBinder absUIBinder = PropertyFactory.getAbsUIBinderFromProperties(parentBinder, object, properties);
            if (absUIBinder == null) continue;
            fieldList.add(absUIBinder);
        }
        return fieldList;
    }

    private static AbsUIBinder getFieldViewWrapper(Field objectField, View fieldView, Object o) {
        AdapterViewField adapterViewField;
        ObjectField objectFieldType;
        CustomField customFieldType;
        ImageField imageField;
        AbsUIBinder absUIBinder = null;
        com.noisyz.bindlibrary.annotations.field.simple.Field simpleFieldType = objectField.getAnnotation(com.noisyz.bindlibrary.annotations.field.simple.Field.class);
        if (simpleFieldType != null) {
            absUIBinder = WrapperViewFactory.getSimplePropertyViewWrapper(simpleFieldType, fieldView, o, objectField);
        }
        if ((imageField = objectField.getAnnotation(ImageField.class)) != null && fieldView instanceof ImageView) {
            absUIBinder = WrapperViewFactory.getImagePropertyViewWrapper(imageField, (ImageView)fieldView, o, objectField);
        }
        if ((customFieldType = objectField.getAnnotation(CustomField.class)) != null) {
            absUIBinder = WrapperViewFactory.getSimplePropertyViewWrapper(customFieldType, fieldView, o, objectField);
        }
        if ((objectFieldType = objectField.getAnnotation(ObjectField.class)) != null) {
            absUIBinder = new ObjectViewBinder(ReflectionUtils.getVariableValue(objectField, o)).registerView(fieldView);
        }
        if ((adapterViewField = objectField.getAnnotation(AdapterViewField.class)) != null) {
            absUIBinder = WrapperViewFactory.getSimpleAdapterViewWrapper(adapterViewField, fieldView, o, objectField);
        }
        return absUIBinder;
    }

    private static List<AbsUIBinder> getMethodPropertyList(ParentBinder parentBinder, Object object, View parentView) {
        ArrayList<AbsUIBinder> methodList = new ArrayList<AbsUIBinder>();
        for (Method method : object.getClass().getDeclaredMethods()) {
            methodList.add(PropertyFactory.getImageGetterMethodProperty(parentBinder, method, object, parentView));
            methodList.add(PropertyFactory.getSimpleGetterMethodProperty(parentBinder, method, object, parentView));
            methodList.add(PropertyFactory.getCustomGetterMethodProperty(parentBinder, method, object, parentView));
            methodList.add(PropertyFactory.getObjectGetterMethodProperty(parentBinder, method, object, parentView));
            methodList.add(PropertyFactory.getSimpleAdapterGetterMethodPropertyList(parentBinder, method, object, parentView));
        }
        return methodList;
    }

    private static AbsUIBinder getSimpleGetterMethodProperty(ParentBinder parentBinder, Method getter, Object object, View parentView) {
        AbsUIBinder absUIBinder = null;
        GetterMethod getterMethod = getter.getAnnotation(GetterMethod.class);
        if (getterMethod != null) {
            String propertyKey = getterMethod.propertyKey();
            if (propertyKey.isEmpty()) {
                propertyKey = parentView.getContext().getString(getterMethod.propertyKeyResId());
            }
            if (!propertyKey.isEmpty()) {
                Method setter = PropertyFactory.getSetterMethod(object, propertyKey);
                SetterMethod setterMethod = null;
                if (setter != null) {
                    setterMethod = setter.getAnnotation(SetterMethod.class);
                }
                ArrayList<View> views = PropertyFactory.getViewsByTag((ViewGroup)parentView, propertyKey);
                ArrayList<AbsUIBinder> properties = new ArrayList<AbsUIBinder>();
                for (View view : views) {
                    PropertyViewWrapper viewWrapper = WrapperViewFactory.getSimplePropertyViewWrapper(propertyKey, getterMethod, setterMethod, view, object, getter, setter);
                    PropertyFactory.updateDataCallbackByParent(parentBinder, properties, viewWrapper);
                }
                absUIBinder = PropertyFactory.getAbsUIBinderFromProperties(parentBinder, object, properties);
            }
        }
        return absUIBinder;
    }

    private static AbsUIBinder getSimpleAdapterGetterMethodPropertyList(ParentBinder parentBinder, Method getter, Object object, View parentView) {
        AbsUIBinder absUIBinder = null;
        SimpleAdapterViewGetter getterMethod = getter.getAnnotation(SimpleAdapterViewGetter.class);
        if (getterMethod != null) {
            String propertyKey = getterMethod.propertyKey();
            if (propertyKey.isEmpty()) {
                propertyKey = parentView.getContext().getString(getterMethod.propertyKeyResId());
            }
            if (!propertyKey.isEmpty()) {
                Method setter = PropertyFactory.getAdapterSetterMethod(object, propertyKey);
                SimpleAdapterViewSetter setterMethod = null;
                if (setter != null) {
                    setterMethod = setter.getAnnotation(SimpleAdapterViewSetter.class);
                }
                ArrayList<View> views = PropertyFactory.getViewsByTag((ViewGroup)parentView, propertyKey);
                ArrayList<AbsUIBinder> properties = new ArrayList<AbsUIBinder>();
                for (View view : views) {
                    PropertyViewWrapper viewWrapper = WrapperViewFactory.getSimpleAdapterViewWrapper(propertyKey, getterMethod, setterMethod, (AdapterView)view, object, getter, setter);
                    PropertyFactory.updateDataCallbackByParent(parentBinder, properties, viewWrapper);
                }
                absUIBinder = PropertyFactory.getAbsUIBinderFromProperties(parentBinder, object, properties);
            }
        }
        return absUIBinder;
    }

    private static AbsUIBinder getCustomGetterMethodProperty(ParentBinder parentBinder, Method getter, Object object, View parentView) {
        AbsUIBinder absUIBinder = null;
        CustomGetterMethod getterMethod = getter.getAnnotation(CustomGetterMethod.class);
        if (getterMethod != null) {
            String propertyKey = getterMethod.propertyKey();
            if (propertyKey.isEmpty()) {
                propertyKey = parentView.getContext().getString(getterMethod.propertyKeyResId());
            }
            if (!propertyKey.isEmpty()) {
                Method setter = PropertyFactory.getCustomSetterMethod(object, propertyKey);
                CustomSetterMethod setterMethod = null;
                if (setter != null) {
                    setterMethod = setter.getAnnotation(CustomSetterMethod.class);
                }
                ArrayList<View> views = PropertyFactory.getViewsByTag((ViewGroup)parentView, propertyKey);
                ArrayList<AbsUIBinder> properties = new ArrayList<AbsUIBinder>();
                for (View view : views) {
                    PropertyViewWrapper viewWrapper = WrapperViewFactory.getSimplePropertyViewWrapper(propertyKey, getterMethod, setterMethod, view, object, getter, setter);
                    PropertyFactory.updateDataCallbackByParent(parentBinder, properties, viewWrapper);
                }
                absUIBinder = PropertyFactory.getAbsUIBinderFromProperties(parentBinder, object, properties);
            }
        }
        return absUIBinder;
    }

    private static AbsUIBinder getObjectGetterMethodProperty(ParentBinder parentBinder, Method getter, Object object, View parentView) {
        AbsUIBinder absUIBinder = null;
        ObjectGetterMethod getterMethod = getter.getAnnotation(ObjectGetterMethod.class);
        if (getterMethod != null) {
            String propertyKey = getterMethod.propertyKey();
            if (propertyKey.isEmpty()) {
                propertyKey = parentView.getContext().getString(getterMethod.propertyKeyResId());
            }
            if (!propertyKey.isEmpty()) {
                ArrayList<View> views = PropertyFactory.getViewsByTag((ViewGroup)parentView, propertyKey);
                ArrayList<AbsUIBinder> properties = new ArrayList<AbsUIBinder>();
                for (View view : views) {
                    absUIBinder = new ObjectViewBinder(ReflectionUtils.invokeGetterMethod(getter, object)).registerView(view);
                    PropertyFactory.updateDataCallbackByParent(parentBinder, properties, absUIBinder);
                }
                absUIBinder = PropertyFactory.getAbsUIBinderFromProperties(parentBinder, object, properties);
            }
        }
        return absUIBinder;
    }

    private static AbsUIBinder getImageGetterMethodProperty(ParentBinder parentBinder, Method method, Object object, View parentView) {
        AbsUIBinder absUIBinder = null;
        ImageGetterMethod imageGetterMethod = method.getAnnotation(ImageGetterMethod.class);
        if (imageGetterMethod != null) {
            String propertyKey = imageGetterMethod.propertyKey();
            if (propertyKey.isEmpty()) {
                propertyKey = parentView.getContext().getString(imageGetterMethod.propertyKeyResId());
            }
            if (!propertyKey.isEmpty()) {
                ArrayList<View> views = PropertyFactory.getViewsByTag((ViewGroup)parentView, propertyKey);
                ArrayList<AbsUIBinder> properties = new ArrayList<AbsUIBinder>();
                for (View view : views) {
                    PropertyViewWrapper viewWrapper;
                    if (!(view instanceof ImageView) || (viewWrapper = WrapperViewFactory.getImagePropertyViewWrapper(propertyKey, imageGetterMethod, (ImageView)view, object, method)) == null) continue;
                    properties.add(viewWrapper);
                }
                absUIBinder = PropertyFactory.getAbsUIBinderFromProperties(parentBinder, object, properties);
            }
        }
        return absUIBinder;
    }

    private static Method getSetterMethod(Object object, String propertyKey) {
        for (Method method : object.getClass().getDeclaredMethods()) {
            SetterMethod setterMethod = method.getAnnotation(SetterMethod.class);
            if (setterMethod == null || !setterMethod.propertyKey().equals(propertyKey)) continue;
            return method;
        }
        return null;
    }

    private static Method getAdapterSetterMethod(Object object, String propertyKey) {
        for (Method method : object.getClass().getDeclaredMethods()) {
            SimpleAdapterViewSetter setterMethod = method.getAnnotation(SimpleAdapterViewSetter.class);
            if (setterMethod == null || !setterMethod.propertyKey().equals(propertyKey)) continue;
            return method;
        }
        return null;
    }

    private static Method getCustomSetterMethod(Object object, String propertyKey) {
        for (Method method : object.getClass().getDeclaredMethods()) {
            SetterMethod setterMethod = method.getAnnotation(SetterMethod.class);
            if (setterMethod == null || !setterMethod.propertyKey().equals(propertyKey)) continue;
            return method;
        }
        return null;
    }

    private static void updateDataCallbackByParent(ParentBinder parentBinder, List<AbsUIBinder> properties, AbsUIBinder viewWrapper) {
        if (viewWrapper != null) {
            properties.add(viewWrapper);
            if (!viewWrapper.hasDataUpdatedCallback() && parentBinder.hasDataUpdatedCallback()) {
                viewWrapper.setDataUpdatedCallback(parentBinder.getDataUpdatedCallback());
            }
        }
    }

    private static AbsUIBinder getAbsUIBinderFromProperties(ParentBinder parentBinder, Object object, List<AbsUIBinder> properties) {
        AbsUIBinder absUIBinder = null;
        if (properties.size() > 1) {
            absUIBinder = new TreeUIBinder(object, parentBinder).addChildren(properties);
        } else if (!properties.isEmpty()) {
            absUIBinder = properties.get(0);
        }
        return absUIBinder;
    }

    private static ArrayList<View> getViewsByTag(ViewGroup root, String tag) {
        ArrayList<View> views = new ArrayList<View>();
        if (root != null) {
            int childCount = root.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                String[] tagsObj;
                Object object;
                View child = root.getChildAt(i);
                if (child instanceof ViewGroup) {
                    views.addAll(PropertyFactory.getViewsByTag((ViewGroup)child, tag));
                }
                if ((object = child.getTag()) == null) continue;
                String objectTagInString = object.toString();
                for (String tagObj : tagsObj = objectTagInString.split("\\|")) {
                    boolean isField;
                    boolean onlyOne = !tagObj.contains("#");
                    boolean bl = isField = onlyOne ? tagObj.equals(tag) : tagObj.contains(tag);
                    if (TextUtils.isEmpty((CharSequence)tagObj) || !isField) continue;
                    views.add(child);
                    String newTag = "";
                    for (int j = 0; j < tagsObj.length; ++j) {
                        newTag = newTag + tagObj;
                        if (j >= tagsObj.length - 1) continue;
                        newTag = newTag + "|";
                    }
                    if (TextUtils.isEmpty((CharSequence)newTag)) {
                        child.setTag(null);
                        continue;
                    }
                    child.setTag((Object)newTag);
                }
            }
        }
        return views;
    }
}

