/*
 * Decompiled with CFR 0.152.
 */
package com.noisyz.bindlibrary.base.impl.adapter.recycler;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.noisyz.bindlibrary.base.impl.ObjectViewBinder;
import com.noisyz.bindlibrary.callback.clickevent.OnElementClickListener;
import com.noisyz.bindlibrary.callback.clickevent.OnElementClickListenerWrapper;
import com.noisyz.bindlibrary.callback.clickevent.OnItemClickListener;
import com.noisyz.bindlibrary.callback.layoutcallback.EmptyBaseLayoutResourceProvider;
import com.noisyz.bindlibrary.callback.layoutcallback.LayoutResourceProvider;
import java.util.ArrayList;
import java.util.List;

public class RecyclerBindAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final int MODE_INVALID = -1;
    private static final int MODE_LIST = 0;
    private static final int MODE_ARRAY = 1;
    protected Object[] os;
    protected List<Object> itemList;
    private int mode;
    private LayoutResourceProvider mLayoutResourceProvider;
    private OnItemClickListener onItemClickListener;
    private ArrayList<OnElementClickListenerWrapper> elementsClickWrappers;

    public RecyclerBindAdapter(List itemList, int layoutResID) {
        this.mLayoutResourceProvider = new EmptyBaseLayoutResourceProvider(layoutResID);
        if (itemList == null) {
            itemList = new ArrayList();
        }
        this.itemList = itemList;
        this.mode = 0;
    }

    public RecyclerBindAdapter(Object[] os, int layoutResID) {
        this.mLayoutResourceProvider = new EmptyBaseLayoutResourceProvider(layoutResID);
        if (os != null) {
            this.os = os;
            this.mode = 1;
        } else {
            this.mode = -1;
        }
    }

    public RecyclerBindAdapter(List itemList, LayoutResourceProvider mLayoutResourceProvider) {
        this(mLayoutResourceProvider);
        if (itemList == null) {
            itemList = new ArrayList();
        }
        this.itemList = itemList;
        this.mode = 0;
    }

    public RecyclerBindAdapter(Object[] os, LayoutResourceProvider mLayoutResourceProvider) {
        this(mLayoutResourceProvider);
        if (os != null) {
            this.os = os;
            this.mode = 1;
        } else {
            this.mode = -1;
        }
    }

    private RecyclerBindAdapter(LayoutResourceProvider mLayoutResourceProvider) {
        this.mLayoutResourceProvider = mLayoutResourceProvider;
        this.elementsClickWrappers = new ArrayList();
    }

    public RecyclerBindAdapter setOnElementClickListener(int elementId, OnElementClickListener onClickListener) {
        this.elementsClickWrappers.add(new OnElementClickListenerWrapper(elementId, onClickListener));
        return this;
    }

    public RecyclerBindAdapter setOnElementsClickListener(int[] elementIds, OnElementClickListener onClickListener) {
        this.elementsClickWrappers.add(new OnElementClickListenerWrapper(elementIds, onClickListener));
        return this;
    }

    public RecyclerBindAdapter setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
        return this;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int itemViewType) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        return new BindViewHolder(inflater.inflate(this.mLayoutResourceProvider.getLayoutResourceID(itemViewType), parent, false));
    }

    public int getItemViewType(int position) {
        return this.mLayoutResourceProvider.getItemViewType(this.getItem(position));
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, final int position) {
        Object o = this.getItem(position);
        BindViewHolder bindViewHolder = (BindViewHolder)holder;
        bindViewHolder.bindView(o);
        final View finalView = bindViewHolder.itemView;
        if (this.onItemClickListener != null) {
            finalView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    RecyclerBindAdapter.this.onItemClickListener.onItemClick(finalView, position, RecyclerBindAdapter.this.getItem(position));
                }
            });
        }
        if (this.elementsClickWrappers != null && !this.elementsClickWrappers.isEmpty()) {
            for (final OnElementClickListenerWrapper wrapper : this.elementsClickWrappers) {
                for (final int elementId : wrapper.getIds()) {
                    View element = finalView.findViewById(elementId);
                    if (element == null) continue;
                    element.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            wrapper.getOnClickListener().onElementClick(finalView, elementId, position, RecyclerBindAdapter.this.getItem(position));
                        }
                    });
                }
            }
        }
    }

    public int getItemCount() {
        switch (this.mode) {
            case 1: {
                return this.os.length;
            }
            case 0: {
                return this.itemList.size();
            }
        }
        return 0;
    }

    public Object getItem(int position) {
        switch (this.mode) {
            case 1: {
                return this.os[position];
            }
            case 0: {
                return this.itemList.get(position);
            }
        }
        return null;
    }

    private class BindViewHolder
    extends RecyclerView.ViewHolder {
        private ObjectViewBinder mObjectViewBinder;

        public BindViewHolder(View itemView) {
            super(itemView);
        }

        public void bindView(Object o) {
            if (this.mObjectViewBinder == null) {
                this.mObjectViewBinder = new ObjectViewBinder(o).registerView(this.itemView);
            } else {
                this.mObjectViewBinder.setObject(o);
            }
            this.mObjectViewBinder.bindUI();
        }
    }
}

