/*
 * Decompiled with CFR 0.152.
 */
package com.noisyz.bindlibrary.wrappers.impl.view.simple;

import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.widget.TextView;
import com.noisyz.bindlibrary.wrappers.impl.view.AbsViewWrapper;

public class TextViewWrapper
extends AbsViewWrapper<TextView> {
    private SimpleTextWatcher textWatcher = new SimpleTextWatcher(){

        @Override
        void onTextChanged(CharSequence text) {
            TextViewWrapper.this.bindObject(text.toString().trim());
        }
    };

    public TextViewWrapper(TextView textView) {
        super(textView);
        textView.addTextChangedListener((TextWatcher)this.textWatcher);
    }

    @Override
    public void bindUI(Object object) {
        ((TextView)this.getView()).removeTextChangedListener((TextWatcher)this.textWatcher);
        if (object instanceof Integer) {
            ((TextView)this.getView()).setText(Integer.valueOf(object.toString()).intValue());
        } else if (object instanceof String) {
            String value = String.valueOf(object);
            if (!TextUtils.isEmpty((CharSequence)value) && !value.equals("null")) {
                ((TextView)this.getView()).setText((CharSequence)value);
            }
            ((TextView)this.getView()).setText((CharSequence)object.toString());
        }
        ((TextView)this.getView()).addTextChangedListener((TextWatcher)this.textWatcher);
    }

    public abstract class SimpleTextWatcher
    implements TextWatcher {
        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void afterTextChanged(Editable s) {
            this.onTextChanged(((TextView)TextViewWrapper.this.getView()).getText());
        }

        abstract void onTextChanged(CharSequence var1);
    }
}

