/*
 * Decompiled with CFR 0.152.
 */
package com.noisyz.bindlibrary.base.impl.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.noisyz.bindlibrary.base.impl.ObjectDataBinder;
import com.noisyz.bindlibrary.callback.clickevent.OnElementClickListener;
import com.noisyz.bindlibrary.callback.clickevent.OnElementClickListenerWrapper;
import com.noisyz.bindlibrary.callback.clickevent.OnItemClickListener;
import com.noisyz.bindlibrary.callback.layoutcallback.BaseLayoutResourceProvider;
import com.noisyz.bindlibrary.callback.layoutcallback.EmptyBaseLayoutResourceProvider;
import java.util.ArrayList;
import java.util.List;

public class BindAdapter
extends BaseAdapter {
    private static final int MODE_INVALID = -1;
    private static final int MODE_LIST = 0;
    private static final int MODE_ARRAY = 1;
    protected Object[] os;
    protected List itemList;
    private int mode;
    private BaseLayoutResourceProvider mLayoutResourceProvider;
    private OnItemClickListener onItemClickListener;
    private List<OnElementClickListenerWrapper> elementsClickWrappers;

    public BindAdapter(List itemList, int layoutResID) {
        this.mLayoutResourceProvider = new EmptyBaseLayoutResourceProvider(layoutResID);
        if (itemList == null) {
            itemList = new ArrayList();
        }
        this.itemList = itemList;
        this.mode = 0;
    }

    public BindAdapter(Object[] os, int layoutResID) {
        this.mLayoutResourceProvider = new EmptyBaseLayoutResourceProvider(layoutResID);
        if (os != null) {
            this.os = os;
            this.mode = 1;
        } else {
            this.mode = -1;
        }
    }

    public BindAdapter(List itemList, BaseLayoutResourceProvider mLayoutResourceProvider) {
        this(mLayoutResourceProvider);
        if (itemList == null) {
            itemList = new ArrayList();
        }
        this.itemList = itemList;
        this.mode = 0;
    }

    public BindAdapter(Object[] os, BaseLayoutResourceProvider mLayoutResourceProvider) {
        this(mLayoutResourceProvider);
        if (os != null) {
            this.os = os;
            this.mode = 1;
        } else {
            this.mode = -1;
        }
    }

    private BindAdapter(BaseLayoutResourceProvider mLayoutResourceProvider) {
        this.mLayoutResourceProvider = mLayoutResourceProvider;
        this.elementsClickWrappers = new ArrayList<OnElementClickListenerWrapper>();
    }

    public BindAdapter setOnElementClickListener(int elementId, OnElementClickListener onClickListener) {
        this.elementsClickWrappers.add(new OnElementClickListenerWrapper(elementId, onClickListener));
        return this;
    }

    public BindAdapter setOnElementsClickListener(int[] elementIds, OnElementClickListener onClickListener) {
        this.elementsClickWrappers.add(new OnElementClickListenerWrapper(elementIds, onClickListener));
        return this;
    }

    public BindAdapter setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
        return this;
    }

    public int getCount() {
        switch (this.mode) {
            case 1: {
                return this.os.length;
            }
            case 0: {
                return this.itemList.size();
            }
        }
        return 0;
    }

    public Object getItem(int position) {
        switch (this.mode) {
            case 1: {
                return this.os[position];
            }
            case 0: {
                return this.itemList.get(position);
            }
        }
        return null;
    }

    public int getItemViewType(int position) {
        return this.mLayoutResourceProvider.getItemViewType(this.getItem(position));
    }

    public int getViewTypeCount() {
        return this.mLayoutResourceProvider.getLayoutCount();
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(final int position, View view, ViewGroup parent) {
        BinderHolder binderHolder = null;
        final Object object = this.getItem(position);
        int currentItemLayoutID = this.mLayoutResourceProvider.getLayoutResourceID(this.getItemViewType(position));
        if (view == null) {
            view = LayoutInflater.from((Context)parent.getContext()).inflate(currentItemLayoutID, null);
            binderHolder = new BinderHolder();
            binderHolder.objectDataBinder = new ObjectDataBinder(object).registerView(view);
            view.setTag((Object)binderHolder);
        } else {
            binderHolder = (BinderHolder)view.getTag();
            binderHolder.objectDataBinder.setObject(object);
        }
        binderHolder.objectDataBinder.bindUI();
        final View finalView = view;
        if (this.onItemClickListener != null) {
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    BindAdapter.this.onItemClickListener.onItemClick(finalView, position, object);
                }
            });
        }
        if (this.elementsClickWrappers != null && !this.elementsClickWrappers.isEmpty()) {
            for (final OnElementClickListenerWrapper wrapper : this.elementsClickWrappers) {
                for (final int elementId : wrapper.getIds()) {
                    View element = view.findViewById(elementId);
                    if (element == null) continue;
                    element.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            wrapper.getOnClickListener().onElementClick(finalView, elementId, position, object);
                        }
                    });
                }
            }
        }
        return view;
    }

    static class BinderHolder {
        ObjectDataBinder objectDataBinder;

        BinderHolder() {
        }
    }
}

