/*
 * Decompiled with CFR 0.152.
 */
package com.noisyz.bindlibrary.base.impl;

import android.app.Activity;
import android.support.v4.app.Fragment;
import android.view.View;
import android.view.ViewGroup;
import com.noisyz.bindlibrary.base.AbsUIBinder;
import com.noisyz.bindlibrary.base.ParentBinder;
import com.noisyz.bindlibrary.base.property.Property;
import com.noisyz.bindlibrary.base.property.PropertyFactory;
import com.noisyz.bindlibrary.callback.DataUpdatedCallback;
import com.noisyz.bindlibrary.conversion.Converter;
import com.noisyz.bindlibrary.wrappers.PropertyViewWrapper;
import java.util.Collections;
import java.util.List;

public class ObjectDataBinder
extends AbsUIBinder
implements ParentBinder,
View.OnAttachStateChangeListener {
    private List<Property> propertyList;
    private View parentView;

    public ObjectDataBinder(Object object) {
        super(object);
    }

    public ObjectDataBinder registerView(Fragment fragment) {
        return this.registerView(fragment.getView());
    }

    public ObjectDataBinder registerView(Activity activity) {
        View viewGroup = ((ViewGroup)activity.findViewById(0x1020002)).getChildAt(0);
        return this.registerView(viewGroup);
    }

    public ObjectDataBinder registerView(View parentView) {
        this.parentView = parentView;
        this.propertyList = PropertyFactory.getPropertyList(this, this.object, parentView);
        this.propertyList.removeAll(Collections.singleton(null));
        return this;
    }

    public View getViewParent() {
        return this.parentView;
    }

    public ObjectDataBinder setUpdateUIConverter(String fieldName, Converter converter) {
        if (this.getPropertyViewWrapper(fieldName) != null) {
            this.getPropertyViewWrapper(fieldName).setUpdateUIConverter(converter);
        }
        return this;
    }

    public ObjectDataBinder setUpdateObjectConverter(String fieldName, Converter converter) {
        if (this.getPropertyViewWrapper(fieldName) != null) {
            this.getPropertyViewWrapper(fieldName).setUpdateObjectConverter(converter);
        }
        return this;
    }

    public ObjectDataBinder setOnElementClick(int elementId, View.OnClickListener onClickListener) {
        View child;
        if (this.parentView != null && (child = this.parentView.findViewById(elementId)) != null) {
            child.setOnClickListener(onClickListener);
        }
        return this;
    }

    public ObjectDataBinder setOnElementsClick(int[] elementsId, View.OnClickListener onClickListener) {
        for (int elementId : elementsId) {
            this.setOnElementClick(elementId, onClickListener);
        }
        return this;
    }

    private PropertyViewWrapper getPropertyViewWrapper(String key) {
        for (Property property : this.propertyList) {
            if (!property.getPropertyName().equals(key)) continue;
            return (PropertyViewWrapper)property.getPropertyBinder();
        }
        return null;
    }

    @Override
    public ObjectDataBinder setDataUpdatedCallback(DataUpdatedCallback callback) {
        super.setDataUpdatedCallback(callback);
        for (Property property : this.propertyList) {
            property.getPropertyBinder().setDataUpdatedCallback(callback);
        }
        return this;
    }

    @Override
    public void bindUI() {
        for (Property property : this.propertyList) {
            property.getPropertyBinder().bindUI();
        }
    }

    @Override
    public void setObject(Object object) {
        super.setObject(object);
        for (Property property : this.propertyList) {
            property.getPropertyBinder().setObject(object);
        }
    }

    @Override
    public void release() {
        super.release();
        for (Property property : this.propertyList) {
            property.release();
        }
        this.propertyList.clear();
        this.propertyList = null;
        this.object = null;
        this.parentView = null;
    }

    public void onViewAttachedToWindow(View view) {
    }

    public void onViewDetachedFromWindow(View view) {
        this.release();
    }

    @Override
    public ObjectDataBinder setDataUpdatedCallback(String propertyKey, DataUpdatedCallback callback) {
        for (Property property : this.propertyList) {
            if (!property.getPropertyName().equals(propertyKey)) continue;
            property.getPropertyBinder().setDataUpdatedCallback(callback);
        }
        return this;
    }
}

