/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.http;

import com.noelios.restlet.http.ChunkedInputStream;
import com.noelios.restlet.http.ChunkedOutputStream;
import com.noelios.restlet.http.HttpClientCall;
import com.noelios.restlet.http.HttpUtils;
import com.noelios.restlet.http.InputEntityStream;
import com.noelios.restlet.http.StreamClientHelper;
import com.noelios.restlet.util.KeepAliveOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Status;
import org.restlet.resource.Representation;
import org.restlet.util.WrapperRepresentation;

public class StreamClientCall
extends HttpClientCall {
    private volatile OutputStream requestEntityStream;
    private volatile OutputStream requestStream;
    private volatile InputStream responseStream;
    private volatile Socket socket;

    private static String getRequestUri(Reference resourceRef) {
        Reference absoluteRef = resourceRef.isAbsolute() ? resourceRef : resourceRef.getTargetRef();
        return absoluteRef.getPath() == null ? absoluteRef.getIdentifier() + "/" : absoluteRef.getIdentifier();
    }

    public StreamClientCall(StreamClientHelper helper, Request request) {
        super(helper, request.getMethod().toString(), StreamClientCall.getRequestUri(request.getResourceRef()));
        this.setVersion("HTTP/1.1");
    }

    public Socket createSocket(String hostDomain, int hostPort) throws UnknownHostException, IOException {
        Socket result = new Socket();
        InetSocketAddress address = new InetSocketAddress(hostDomain, hostPort);
        result.connect(address, this.getHelper().getConnectTimeout());
        return result;
    }

    public StreamClientHelper getHelper() {
        return (StreamClientHelper)super.getHelper();
    }

    protected Representation getRepresentation(InputStream stream) {
        Representation result = super.getRepresentation(stream);
        return new SocketWrapperRepresentation(result, this.socket, this.getHelper().getLogger());
    }

    public WritableByteChannel getRequestEntityChannel() {
        return null;
    }

    public OutputStream getRequestEntityStream() {
        if (this.requestEntityStream == null) {
            this.requestEntityStream = this.isRequestChunked() ? (this.isKeepAlive() ? new ChunkedOutputStream(new KeepAliveOutputStream(this.getRequestHeadStream())) : new ChunkedOutputStream(this.getRequestHeadStream())) : new KeepAliveOutputStream(this.getRequestHeadStream());
        }
        return this.requestEntityStream;
    }

    public OutputStream getRequestHeadStream() {
        return this.requestStream;
    }

    public ReadableByteChannel getResponseEntityChannel(long size) {
        return null;
    }

    public InputStream getResponseEntityStream(long size) {
        if (this.isResponseChunked()) {
            return new ChunkedInputStream(this.getResponseStream());
        }
        if (size >= 0L) {
            return new InputEntityStream(this.getResponseStream(), size);
        }
        return this.getResponseStream();
    }

    private InputStream getResponseStream() {
        return this.responseStream;
    }

    protected boolean isClientKeepAlive() {
        return false;
    }

    protected void parseResponse() throws IOException {
        StringBuilder sb = new StringBuilder();
        int next = this.getResponseStream().read();
        while (next != -1 && !HttpUtils.isSpace(next)) {
            sb.append((char)next);
            next = this.getResponseStream().read();
        }
        if (next == -1) {
            throw new IOException("Unable to parse the response HTTP version. End of stream reached too early.");
        }
        this.setVersion(sb.toString());
        sb.delete(0, sb.length());
        next = this.getResponseStream().read();
        while (next != -1 && !HttpUtils.isSpace(next)) {
            sb.append((char)next);
            next = this.getResponseStream().read();
        }
        if (next == -1) {
            throw new IOException("Unable to parse the response status. End of stream reached too early.");
        }
        this.setStatusCode(Integer.parseInt(sb.toString()));
        sb.delete(0, sb.length());
        next = this.getResponseStream().read();
        while (next != -1 && !HttpUtils.isCarriageReturn(next)) {
            sb.append((char)next);
            next = this.getResponseStream().read();
        }
        if (next == -1) {
            throw new IOException("Unable to parse the reason phrase. End of stream reached too early.");
        }
        next = this.getResponseStream().read();
        if (HttpUtils.isLineFeed(next)) {
            this.setReasonPhrase(sb.toString());
            sb.delete(0, sb.length());
            Parameter header = HttpUtils.readHeader(this.getResponseStream(), sb);
            while (header != null) {
                this.getResponseHeaders().add((Object)header);
                header = HttpUtils.readHeader(this.getResponseStream(), sb);
            }
        } else {
            throw new IOException("Unable to parse the reason phrase. The carriage return must be followed by a line feed.");
        }
    }

    public Status sendRequest(Request request) {
        Status result = null;
        try {
            Reference resourceRef = request.getResourceRef().isRelative() ? request.getResourceRef().getTargetRef() : request.getResourceRef();
            String hostDomain = resourceRef.getHostDomain();
            int hostPort = resourceRef.getHostPort();
            if (hostPort == -1) {
                hostPort = resourceRef.getSchemeProtocol() != null ? resourceRef.getSchemeProtocol().getDefaultPort() : this.getProtocol().getDefaultPort();
            }
            this.socket = this.createSocket(hostDomain, hostPort);
            this.socket.setTcpNoDelay(this.getHelper().getTcpNoDelay());
            this.requestStream = new BufferedOutputStream(this.socket.getOutputStream());
            this.responseStream = new BufferedInputStream(this.socket.getInputStream());
            this.getRequestHeadStream().write(this.getMethod().getBytes());
            this.getRequestHeadStream().write(32);
            this.getRequestHeadStream().write(this.getRequestUri().getBytes());
            this.getRequestHeadStream().write(32);
            this.getRequestHeadStream().write(this.getVersion().getBytes());
            HttpUtils.writeCRLF(this.getRequestHeadStream());
            if (this.shouldRequestBeChunked(request)) {
                this.getRequestHeaders().set("Transfer-Encoding", "chunked", true);
            }
            this.getRequestHeaders().set("Connection", "close", this.isClientKeepAlive());
            String host = hostDomain;
            if (resourceRef.getHostPort() != -1) {
                host = host + ":" + resourceRef.getHostPort();
            }
            this.getRequestHeaders().set("Host", host, true);
            for (Parameter header : this.getRequestHeaders()) {
                HttpUtils.writeHeader(header, this.getRequestHeadStream());
            }
            HttpUtils.writeCRLF(this.getRequestHeadStream());
            this.getRequestHeadStream().flush();
            result = super.sendRequest(request);
            if (result.equals((Object)Status.CONNECTOR_ERROR_COMMUNICATION)) {
                return result;
            }
            this.parseResponse();
            result = new Status(this.getStatusCode(), null, this.getReasonPhrase(), null);
        }
        catch (IOException ioe) {
            this.getHelper().getLogger().log(Level.WARNING, "An error occured during the communication with the remote HTTP server.", ioe);
            result = new Status(Status.CONNECTOR_ERROR_COMMUNICATION, (Throwable)ioe);
        }
        return result;
    }

    private static class SocketWrapperRepresentation
    extends WrapperRepresentation {
        private final Logger log;
        private final Socket socket;

        public SocketWrapperRepresentation(Representation wrappedRepresentation, Socket socket, Logger log) {
            super(wrappedRepresentation);
            this.socket = socket;
            this.log = log;
        }

        public void release() {
            try {
                if (!this.socket.isClosed()) {
                    this.socket.shutdownOutput();
                    this.socket.close();
                }
            }
            catch (IOException ex) {
                this.log.log(Level.WARNING, "An error occured closing the client socket", ex);
            }
            super.release();
        }
    }
}

