/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.http;

import com.noelios.restlet.ServerHelper;
import com.noelios.restlet.http.HttpRequest;
import com.noelios.restlet.http.HttpResponse;
import com.noelios.restlet.http.HttpServerCall;
import com.noelios.restlet.http.HttpServerConverter;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Server;
import org.restlet.util.Engine;

public class HttpServerHelper
extends ServerHelper {
    private volatile HttpServerConverter converter = null;

    public HttpServerHelper() {
        this(null);
    }

    public HttpServerHelper(Server server) {
        super(server);
    }

    public HttpServerConverter getConverter() {
        if (this.converter == null) {
            try {
                String converterClass = this.getHelpedParameters().getFirstValue("converter", "com.noelios.restlet.http.HttpServerConverter");
                this.converter = (HttpServerConverter)Engine.loadClass((String)converterClass).getConstructor(Context.class).newInstance(this.getContext());
            }
            catch (IllegalArgumentException e) {
                this.getLogger().log(Level.SEVERE, "Unable to create the HTTP server converter", e);
            }
            catch (SecurityException e) {
                this.getLogger().log(Level.SEVERE, "Unable to create the HTTP server converter", e);
            }
            catch (InstantiationException e) {
                this.getLogger().log(Level.SEVERE, "Unable to create the HTTP server converter", e);
            }
            catch (IllegalAccessException e) {
                this.getLogger().log(Level.SEVERE, "Unable to create the HTTP server converter", e);
            }
            catch (InvocationTargetException e) {
                this.getLogger().log(Level.SEVERE, "Unable to create the HTTP server converter", e);
            }
            catch (NoSuchMethodException e) {
                this.getLogger().log(Level.SEVERE, "Unable to create the HTTP server converter", e);
            }
            catch (ClassNotFoundException e) {
                this.getLogger().log(Level.SEVERE, "Unable to create the HTTP server converter", e);
            }
        }
        return this.converter;
    }

    public void handle(HttpServerCall httpCall) {
        try {
            HttpRequest request = this.getConverter().toRequest(httpCall);
            HttpResponse response = new HttpResponse(httpCall, request);
            this.handle(request, response);
            this.getConverter().commit(response);
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Error while handling an HTTP server call: ", e.getMessage());
            this.getLogger().log(Level.INFO, "Error while handling an HTTP server call", e);
        }
    }

    public void setConverter(HttpServerConverter converter) {
        this.converter = converter;
    }
}

