/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.authentication;

import com.noelios.restlet.authentication.AuthenticationHelper;
import com.noelios.restlet.util.Base64;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Parameter;
import org.restlet.data.Request;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpBasicHelper
extends AuthenticationHelper {
    public HttpBasicHelper() {
        super(ChallengeScheme.HTTP_BASIC, true, true);
    }

    @Override
    public void formatCredentials(StringBuilder sb, ChallengeResponse challenge, Request request, Series<Parameter> httpHeaders) {
        try {
            String credentials = challenge.getIdentifier() + ':' + new String(challenge.getSecret());
            sb.append(Base64.encode(credentials.getBytes("ISO-8859-1"), false));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding, unable to encode credentials");
        }
    }

    @Override
    public void parseResponse(ChallengeResponse cr, Request request) {
        try {
            String credentials;
            int separator;
            System.out.println("cr.getCredentials()" + cr.getCredentials());
            byte[] credentialsEncoded = Base64.decode(cr.getCredentials());
            if (credentialsEncoded == null) {
                this.getLogger().warning("Cannot decode credentials: " + cr.getCredentials());
            }
            if ((separator = (credentials = new String(credentialsEncoded, "ISO-8859-1")).indexOf(58)) == -1) {
                this.getLogger().warning("Invalid credentials given by client with IP: " + (request != null ? request.getClientInfo().getAddress() : "?"));
            } else {
                cr.setIdentifier(credentials.substring(0, separator));
                cr.setSecret(credentials.substring(separator + 1));
            }
        }
        catch (UnsupportedEncodingException e) {
            this.getLogger().log(Level.WARNING, "Unsupported encoding error", e);
        }
    }
}

