/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.application;

import com.noelios.restlet.application.RangeRepresentation;
import org.restlet.Context;
import org.restlet.Filter;
import org.restlet.data.Method;
import org.restlet.data.Range;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Representation;
import org.restlet.service.RangeService;

public class RangeFilter
extends Filter {
    public RangeFilter(Context context) {
        super(context);
    }

    protected void afterHandle(Request request, Response response) {
        if (this.getRangeService().isEnabled()) {
            response.getServerInfo().setAcceptRanges(true);
            if (response.isEntityAvailable()) {
                if (request.getRanges().size() == 1) {
                    Range requestedRange = (Range)request.getRanges().get(0);
                    if (response.getEntity().getSize() == -1L) {
                        if (!(requestedRange.getIndex() != -1L && requestedRange.getSize() != -1L || requestedRange.getIndex() == -1L && requestedRange.getSize() == -1L)) {
                            response.setStatus(Status.SERVER_ERROR_INTERNAL);
                            this.getLogger().warning("Unable to serve this range since at least the end index of the range cannot be computed.");
                            response.setEntity(null);
                        }
                    } else {
                        boolean rangeEntity;
                        boolean bl = rangeEntity = response.getEntity().getRange() != null;
                        if (!requestedRange.equals((Object)response.getEntity().getRange())) {
                            if (rangeEntity) {
                                this.getLogger().info("The range of the response entity is not equal to the requested one.");
                            }
                            response.setEntity((Representation)new RangeRepresentation(response.getEntity(), requestedRange));
                        }
                        if ((Method.GET.equals((Object)request.getMethod()) || Method.HEAD.equals((Object)request.getMethod())) && response.getStatus().isSuccess() && !Status.SUCCESS_PARTIAL_CONTENT.equals((Object)response.getStatus())) {
                            response.setStatus(Status.SUCCESS_PARTIAL_CONTENT);
                            if (rangeEntity) {
                                this.getLogger().info("The status of a response to a partial GET must be \"206 Partial content\".");
                            }
                        }
                    }
                } else if (request.getRanges().size() > 1) {
                    response.setStatus(Status.SERVER_ERROR_NOT_IMPLEMENTED);
                    this.getLogger().warning("Multiple ranges are not supported at this time.");
                    response.setEntity(null);
                }
            }
        }
    }

    public RangeService getRangeService() {
        return this.getApplication().getRangeService();
    }
}

