/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.application;

import com.noelios.restlet.application.RangeInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.WritableByteChannel;
import org.restlet.data.Range;
import org.restlet.resource.Representation;
import org.restlet.util.ByteUtils;
import org.restlet.util.WrapperRepresentation;

public class RangeRepresentation
extends WrapperRepresentation {
    public RangeRepresentation(Representation wrappedRepresentation) {
        this(wrappedRepresentation, null);
    }

    public RangeRepresentation(Representation wrappedRepresentation, Range range) {
        super(wrappedRepresentation);
        if (wrappedRepresentation.getRange() != null) {
            throw new IllegalArgumentException("The wrapped representation must not have a range set.");
        }
        this.setRange(range);
    }

    public InputStream getStream() throws IOException {
        return new RangeInputStream(super.getStream(), this.getSize(), this.getRange());
    }

    public void write(OutputStream outputStream) throws IOException {
        ByteUtils.write((InputStream)this.getStream(), (OutputStream)outputStream);
    }

    public void write(WritableByteChannel writableChannel) throws IOException {
        this.write(ByteUtils.getStream((WritableByteChannel)writableChannel));
    }
}

