/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.ext.simple;

import com.noelios.restlet.ext.simple.SimplePipelineFactory;
import com.noelios.restlet.ext.simple.SimpleProtocolHandler;
import com.noelios.restlet.ext.simple.SimpleServerHelper;
import com.noelios.restlet.http.HttpsUtils;
import com.noelios.restlet.util.SslContextFactory;
import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.TrustManagerFactory;
import org.restlet.Server;
import org.restlet.data.Protocol;
import org.restlet.util.Helper;
import simple.http.PipelineFactory;
import simple.http.PipelineHandler;
import simple.http.PipelineHandlerFactory;
import simple.http.ProtocolHandler;
import simple.http.connect.ConnectionFactory;

public class HttpsServerHelper
extends SimpleServerHelper {
    public HttpsServerHelper(Server server) {
        super(server);
        this.getProtocols().add(Protocol.HTTPS);
    }

    public String getCertAlgorithm() {
        return this.getHelpedParameters().getFirstValue("certAlgorithm", "SunX509");
    }

    public String getKeyPassword() {
        return this.getHelpedParameters().getFirstValue("keyPassword", "");
    }

    public String getKeystorePassword() {
        return this.getHelpedParameters().getFirstValue("keystorePassword", "");
    }

    public String getKeystorePath() {
        return this.getHelpedParameters().getFirstValue("keystorePath", System.getProperty("user.home") + File.separator + ".keystore");
    }

    public String getKeystoreType() {
        return this.getHelpedParameters().getFirstValue("keystoreType", "JKS");
    }

    public String getSslProtocol() {
        return this.getHelpedParameters().getFirstValue("sslProtocol", "TLS");
    }

    public boolean isNeedClientAuthentication() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("needClientAuthentication", "false"));
    }

    public boolean isWantClientAuthentication() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("wantClientAuthentication", "false"));
    }

    public void start() throws Exception {
        SSLContext sslContext;
        SslContextFactory sslContextFactory = HttpsUtils.getSslContextFactory((Helper)this);
        if (sslContextFactory == null) {
            KeyStore keyStore = KeyStore.getInstance(this.getKeystoreType());
            FileInputStream fis = this.getKeystorePath() == null ? null : new FileInputStream(this.getKeystorePath());
            char[] password = this.getKeystorePassword() == null ? null : this.getKeystorePassword().toCharArray();
            keyStore.load(fis, password);
            if (fis != null) {
                fis.close();
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this.getCertAlgorithm());
            keyManagerFactory.init(keyStore, this.getKeyPassword().toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this.getCertAlgorithm());
            trustManagerFactory.init(keyStore);
            sslContext = SSLContext.getInstance(this.getSslProtocol());
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        } else {
            sslContext = sslContextFactory.createSslContext();
        }
        SSLServerSocket serverSocket = null;
        String addr = ((Server)this.getHelped()).getAddress();
        if (addr != null) {
            InetAddress iaddr = InetAddress.getByName(addr);
            serverSocket = (SSLServerSocket)sslContext.getServerSocketFactory().createServerSocket(((Server)this.getHelped()).getPort(), 50, iaddr);
        } else {
            serverSocket = (SSLServerSocket)sslContext.getServerSocketFactory().createServerSocket(((Server)this.getHelped()).getPort());
        }
        if (this.isNeedClientAuthentication()) {
            serverSocket.setNeedClientAuth(true);
        } else if (this.isWantClientAuthentication()) {
            serverSocket.setWantClientAuth(true);
        }
        String[] enabledCipherSuites = HttpsUtils.getEnabledCipherSuites((Helper)this);
        String[] excludedCipherSuites = HttpsUtils.getDisabledCipherSuites((Helper)this);
        if (excludedCipherSuites != null) {
            if (enabledCipherSuites == null) {
                enabledCipherSuites = serverSocket.getEnabledCipherSuites();
            }
            ArrayList<String> enabledCipherSuitesList = new ArrayList<String>(Arrays.asList(enabledCipherSuites));
            for (String excludedCipherSuite : excludedCipherSuites) {
                enabledCipherSuitesList.remove(excludedCipherSuite);
            }
            enabledCipherSuites = enabledCipherSuitesList.toArray(enabledCipherSuites);
        }
        if (enabledCipherSuites != null) {
            serverSocket.setEnabledCipherSuites(enabledCipherSuites);
        }
        serverSocket.setSoTimeout(60000);
        this.setSocket(serverSocket);
        this.setConfidential(true);
        this.setHandler(PipelineHandlerFactory.getInstance((ProtocolHandler)new SimpleProtocolHandler(this), (int)this.getDefaultThreads(), (int)this.getMaxWaitTimeMs()));
        this.setConnection(ConnectionFactory.getConnection((PipelineHandler)this.getHandler(), (PipelineFactory)new SimplePipelineFactory()));
        this.getConnection().connect(this.getSocket());
        super.start();
    }
}

