/*
 * Decompiled with CFR 0.152.
 */
package com.nmote.oembed.embedly;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nmote.oembed.AbstractOEmbedProvider;
import com.nmote.oembed.ProviderEndpoint;
import com.nmote.oembed.embedly.EmbedlyEmbed;
import java.util.Objects;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class EmbedlyProvider
extends AbstractOEmbedProvider {
    private static final ProviderEndpoint PROVIDER_ENDPOINT = new ProviderEndpoint("http://api.embed.ly/1/oembed", EmbedlyEmbed.class);
    private final String apiKey;

    public EmbedlyProvider(String apiKey) {
        Objects.requireNonNull(apiKey);
        this.apiKey = apiKey;
    }

    public EmbedlyProvider(String apiKey, OkHttpClient httpClient, ObjectMapper mapper) {
        super(httpClient, mapper);
        Objects.requireNonNull(apiKey);
        this.apiKey = apiKey;
    }

    @Override
    protected ProviderEndpoint getProviderEndpointFor(String url) {
        return PROVIDER_ENDPOINT;
    }

    @Override
    protected void prepareRequestURI(HttpUrl.Builder builder, String url, Integer ... maxSize) {
        super.prepareRequestURI(builder, url, maxSize);
        builder.addQueryParameter("key", this.apiKey);
    }
}

