/*
 * Decompiled with CFR 0.152.
 */
package com.nmote.oembed;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nmote.oembed.ProviderEndpoint;
import com.nmote.oembed.ToJsonString;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ProviderInfo {
    @JsonProperty(value="endpoints")
    private List<ProviderEndpoint> endpoints;
    @JsonProperty(value="provider_name")
    private String providerName;
    @JsonProperty(value="provider_url")
    private String providerUrl;

    public ProviderInfo(String name, String url, List<ProviderEndpoint> endpoints) {
        this.setProviderName(name);
        this.setProviderUrl(url);
        this.setEndpoints(endpoints);
    }

    public ProviderInfo(String name, String url, ProviderEndpoint ... endpoints) {
        this(name, url, Arrays.asList(endpoints));
    }

    ProviderInfo() {
        this.endpoints = Collections.emptyList();
    }

    public List<ProviderEndpoint> getEndpoints() {
        return this.endpoints;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getProviderUrl() {
        return this.providerUrl;
    }

    public void setEndpoints(List<ProviderEndpoint> endpoints) {
        Objects.requireNonNull(endpoints);
        this.endpoints = endpoints;
    }

    public void setProviderName(String providerName) {
        Objects.requireNonNull(providerName);
        this.providerName = providerName;
    }

    public void setProviderUrl(String providerUrl) {
        Objects.requireNonNull(providerUrl);
        this.providerUrl = providerUrl;
    }

    public String toString() {
        return ToJsonString.toJsonString(this);
    }
}

