/*
 * Decompiled with CFR 0.152.
 */
package com.nmote.oembed;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nmote.oembed.BasicOEmbed;
import com.nmote.oembed.ToJsonString;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class ProviderEndpoint {
    Class<? extends BasicOEmbed> embedClass;
    @JsonProperty(value="discovery")
    private boolean discovery;
    @JsonProperty(value="formats")
    private Set<String> formats = Collections.singleton("json");
    @JsonProperty(value="schemes")
    private Set<String> schemes;
    @JsonProperty(value="url")
    private String url;

    public ProviderEndpoint(String url) {
        this(url, null);
    }

    public ProviderEndpoint(String url, Class<? extends BasicOEmbed> embedClass) {
        this(url, embedClass, Collections.emptySet());
    }

    public ProviderEndpoint(String url, Class<? extends BasicOEmbed> embedClass, Set<String> schemes) {
        this.setUrl(url);
        this.embedClass = embedClass;
        this.setSchemes(schemes);
    }

    public ProviderEndpoint(String url, Class<? extends BasicOEmbed> embedClass, String ... schemes) {
        this(url, embedClass, new HashSet<String>(Arrays.asList(schemes)));
    }

    ProviderEndpoint() {
        this.schemes = Collections.emptySet();
    }

    @JsonProperty(value="embed_class")
    public String getEmbedClass() {
        return this.embedClass != null ? this.embedClass.getName() : null;
    }

    public Set<String> getFormats() {
        return this.formats;
    }

    public Set<String> getSchemes() {
        return this.schemes;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isDiscovery() {
        return this.discovery;
    }

    public void setDiscovery(boolean discovery) {
        this.discovery = discovery;
    }

    public void setEmbedClass(String className) throws ClassNotFoundException {
        this.embedClass = Class.forName(className);
    }

    public void setFormats(Set<String> formats) {
        this.formats = formats;
    }

    public void setSchemes(Set<String> schemes) {
        Objects.requireNonNull(schemes);
        this.schemes = schemes;
    }

    public void setUrl(String endpointUrl) {
        Objects.requireNonNull(endpointUrl);
        this.url = endpointUrl;
    }

    public String toString() {
        return ToJsonString.toJsonString(this);
    }
}

