/*
 * Decompiled with CFR 0.152.
 */
package com.nmote.oembed;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class Link {
    private List<Parameter> params;
    private String uri;

    public static void main(String[] args) {
        String[] links;
        String[] stringArray = links = new String[]{" <http://example.com/TheBook/chapter2>; rel=\"previous\"; title=\"previous chapter\"", "</>; rel=\"http://example.net/foo\"", "</TheBook/chapter2>;\n       rel=\"previous\"; title*=UTF-8'de'letztes%20Kapitel", "<http://example.org/>;\n             rel=\"start http://example.net/relation/other\""};
        int n = links.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            System.out.println(Link.parse(a));
            ++n2;
        }
    }

    public static Link parse(String header) {
        String name;
        Link link = new Link(header);
        LinkTokenizer tok = new LinkTokenizer(header);
        link.uri = tok.readURI();
        link.params = new ArrayList<Parameter>();
        while ((name = tok.readName()) != null) {
            String value = tok.readValue();
            link.params.add(new Parameter(name, value));
        }
        return link;
    }

    public Link() {
    }

    public Link(String uri) {
        Objects.requireNonNull(uri);
        this.uri = uri;
        this.params = new ArrayList<Parameter>();
    }

    public String get(String name) {
        for (Parameter p : this.params) {
            if (!name.equals(p.getName())) continue;
            return p.getValue();
        }
        return null;
    }

    public List<Parameter> getParameters() {
        return this.params;
    }

    public String getRel() {
        return this.get("title");
    }

    public String getTitle() {
        return this.get("title");
    }

    public String getUri() {
        return this.uri;
    }

    public boolean hasRel(String rel) {
        String r = this.getRel();
        if (r == null) {
            return false;
        }
        StringTokenizer tok = new StringTokenizer(r);
        while (tok.hasMoreElements()) {
            if (!tok.nextElement().equals(rel)) continue;
            return true;
        }
        return false;
    }

    public Link rel(String rel) {
        this.remove("rel");
        this.params.add(0, new Parameter("rel", rel));
        return this;
    }

    public Link remove(String name) {
        Iterator<Parameter> i = this.params.iterator();
        while (i.hasNext()) {
            if (!name.equals(i.next().getName())) continue;
            i.remove();
        }
        return this;
    }

    public Link title(String title) {
        this.remove("rel");
        this.params.add(new Parameter("title", title));
        return this;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('<').append(this.uri).append('>');
        Pattern needQuote = Pattern.compile("[\n\t:/ \"]");
        for (Parameter p : this.params) {
            b.append("; ").append(p.getName()).append('=');
            String v = p.getValue();
            if (needQuote.matcher(v).find()) {
                b.append('\"');
                b.append(v.replace("\"", "\\\""));
                b.append('\"');
                continue;
            }
            b.append(v);
        }
        return b.toString();
    }

    public Link uri(String uri) {
        this.uri = uri;
        return this;
    }

    private static class LinkTokenizer {
        private StringBuilder buffer;
        private String in;
        private int pos;

        public LinkTokenizer(String in) {
            this.in = in;
            this.pos = 0;
            this.buffer = new StringBuilder(32);
        }

        public String readName() {
            char c;
            if (this.pos >= this.in.length()) {
                return null;
            }
            int end = this.pos + 1;
            while ((c = this.in.charAt(end)) != ';' && c != '=' && ++end < this.in.length()) {
            }
            String result = this.in.substring(this.pos, end).trim();
            this.pos = end;
            return result;
        }

        public String readURI() {
            int idx1 = this.in.indexOf(60, this.pos);
            if (idx1 == -1) {
                throw new IllegalStateException("expected '<': " + this.in.substring(this.pos));
            }
            int idx2 = this.in.indexOf(62, idx1 + 1);
            if (idx2 == -1) {
                throw new IllegalStateException("expected '>': " + this.in.substring(this.pos));
            }
            String result = this.in.substring(idx1 + 1, idx2);
            this.pos = idx2 + 1;
            this.skipToName();
            return result;
        }

        public String readValue() {
            String result;
            if (this.pos >= this.in.length()) {
                return null;
            }
            char c = this.in.charAt(this.pos);
            if (c == ';') {
                ++this.pos;
                result = null;
            } else if (c == '=') {
                ++this.pos;
                c = this.in.charAt(this.pos);
                result = c == '\"' ? this.readQuoted() : this.readToken();
            } else {
                throw new RuntimeException();
            }
            this.skipLWS();
            return result;
        }

        private String readQuoted() {
            this.buffer.setLength(0);
            ++this.pos;
            while (this.pos < this.in.length()) {
                char c;
                if ((c = this.in.charAt(this.pos++)) == '\\' && this.in.charAt(this.pos) == '\"') {
                    this.buffer.append('\"');
                    ++this.pos;
                    continue;
                }
                if (c == '\"') {
                    this.skipToName();
                    break;
                }
                this.buffer.append(c);
            }
            return this.buffer.toString();
        }

        private String readToken() {
            this.buffer.setLength(0);
            while (this.pos < this.in.length()) {
                char c;
                if ((c = this.in.charAt(this.pos++)) == ';' || Character.isSpaceChar(c)) {
                    this.skipLWS();
                    break;
                }
                this.buffer.append(c);
            }
            return this.buffer.toString();
        }

        private void skipLWS() {
            while (this.pos < this.in.length() && Character.isSpaceChar(this.in.charAt(this.pos))) {
                ++this.pos;
            }
        }

        private void skipToName() {
            this.skipLWS();
            if (this.pos < this.in.length() && this.in.charAt(this.pos) == ';') {
                ++this.pos;
                this.skipLWS();
            }
        }
    }

    public static class Parameter {
        private String name;
        private String value;

        public Parameter(String name, String value) {
            assert (name != null);
            assert (value != null);
            this.name = name.intern();
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.name) + "=\"" + this.value + '\"';
        }
    }
}

