/*
 * Decompiled with CFR 0.152.
 */
package com.nmote.oembed;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nmote.oembed.AbstractOEmbedProvider;
import com.nmote.oembed.BasicOEmbed;
import com.nmote.oembed.Link;
import com.nmote.oembed.OEmbed;
import com.nmote.oembed.ProviderEndpoint;
import com.nmote.oembed.ProviderInfo;
import com.nmote.oembed.SimpleImageInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class DefaultOEmbedProvider
extends AbstractOEmbedProvider {
    private List<ProviderInfo> providers;

    public static void main(String[] args) throws IOException {
        DefaultOEmbedProvider ep = new DefaultOEmbedProvider();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            System.out.println("Fetching " + arg);
            OEmbed e = ep.resolve(arg, new Integer[0]);
            System.out.println(e);
            System.out.println();
            ++n2;
        }
    }

    private static boolean matchGlob(String text, String glob) {
        String rest = null;
        int pos = glob.indexOf(42);
        if (pos != -1) {
            rest = glob.substring(pos + 1);
            glob = glob.substring(0, pos);
        }
        if (glob.length() > text.length()) {
            return false;
        }
        int i = 0;
        while (i < glob.length()) {
            char b;
            char a = glob.charAt(i);
            if (a != (b = text.charAt(i)) && a != '?') {
                return false;
            }
            ++i;
        }
        if (rest == null) {
            return glob.length() == text.length();
        }
        i = glob.length();
        while (i <= text.length()) {
            if (DefaultOEmbedProvider.matchGlob(text.substring(i), rest)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public DefaultOEmbedProvider() throws IOException {
        this.loadProviders();
    }

    public DefaultOEmbedProvider(OkHttpClient httpClient, ObjectMapper mapper) throws IOException {
        super(httpClient, mapper);
        this.loadProviders();
    }

    @Override
    public ProviderEndpoint getProviderEndpointFor(String url) {
        for (ProviderInfo p : this.providers) {
            for (ProviderEndpoint e : p.getEndpoints()) {
                if (!this.endpointSupports(e, url)) continue;
                return e;
            }
        }
        return null;
    }

    public List<ProviderInfo> getProviders() {
        return this.providers;
    }

    public ProviderInfo getProviderByName(String name) {
        for (ProviderInfo pi : this.providers) {
            if (!pi.getProviderName().equals(name)) continue;
            return pi;
        }
        return null;
    }

    @Override
    public OEmbed resolve(String url, Integer ... maxSize) throws IOException {
        String faviconUrl;
        OEmbed boe;
        ProviderEndpoint p = this.getProviderEndpointFor(url);
        OEmbed result = p != null ? super.resolve(url, p, maxSize) : this.discover(url, maxSize);
        if (result instanceof BasicOEmbed && ((BasicOEmbed)(boe = result)).getFaviconUrl() == null && this.checkFaviconUrl(faviconUrl = new URL(new URL(url), "/favicon.ico").toExternalForm())) {
            ((BasicOEmbed)boe).setFaviconUrl(faviconUrl);
        }
        return result;
    }

    protected boolean endpointSupports(ProviderEndpoint provider, String url) {
        if (provider.getSchemes() != null) {
            for (String scheme : provider.getSchemes()) {
                if (!DefaultOEmbedProvider.matchGlob(url, scheme)) continue;
                return true;
            }
        }
        return false;
    }

    private BasicOEmbed discover(String url, Integer ... maxSize) throws IOException {
        Request request = new Request.Builder().url(url).build();
        Response response = this.httpClient.newCall(request).execute();
        if (response.isSuccessful()) {
            BasicOEmbed result;
            block15: {
                String finalUrl = url;
                result = new BasicOEmbed();
                result.setUrl(finalUrl);
                MediaType contentType = response.body().contentType();
                this.extractPingbackUrl(result, response);
                this.extractWebmentionUrl(result, response);
                if (contentType.subtype().equals("json")) {
                    Throwable throwable = null;
                    Object var9_10 = null;
                    try (InputStream in = response.body().byteStream();){
                        result = (BasicOEmbed)this.mapper.readValue(in, BasicOEmbed.class);
                        break block15;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                if (contentType.type().equals("image")) {
                    result = this.photo(result, response, maxSize);
                } else if (contentType.subtype().equals("html")) {
                    result = this.document(result, response, maxSize);
                } else {
                    result.setType("link");
                }
            }
            return result;
        }
        throw new IOException(String.format("HTTP %d/%s while getting %s", response.code(), response.message(), url));
    }

    private boolean checkFaviconUrl(String url) {
        Request request = new Request.Builder().url(url).head().build();
        boolean result = false;
        try {
            Response response = this.httpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                MediaType contentType = response.body().contentType();
                result = "image".equals(contentType.type());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private BasicOEmbed document(BasicOEmbed result, Response response, Integer ... maxSize) throws IOException {
        Element anchor;
        Document doc;
        Charset charset = response.body().contentType().charset();
        Throwable throwable = null;
        Iterator iterator = null;
        try (InputStream in = response.body().byteStream();){
            doc = Jsoup.parse((InputStream)in, (String)(charset != null ? charset.toString() : "UTF-8"), (String)result.getUrl());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        result.setType("link");
        result.setTitle(doc.title());
        for (Element meta : doc.head().getElementsByTag("meta")) {
            String content = meta.attr("content");
            switch (meta.attr("name").toLowerCase()) {
                case "description": 
                case "og:description": 
                case "twitter:description": {
                    result.setDescription(content);
                    break;
                }
                case "author": {
                    result.setAuthorName(content);
                }
            }
        }
        for (Element link : doc.head().getElementsByTag("link")) {
            String rel = link.attr("rel");
            if (rel == null) continue;
            String type = link.attr("type");
            String href = link.absUrl("href");
            if (result.getFaviconUrl() == null && ("icon".equals(rel) || "shortcut icon".equals(rel)) || rel.startsWith("apple-touch-icon")) {
                if (!this.checkFaviconUrl(href)) continue;
                result.setFaviconUrl(href);
                continue;
            }
            if ("application/json+oembed".equals(type)) {
                if (maxSize != null) {
                    if (maxSize.length > 0 && maxSize[0] != null) {
                        href = String.valueOf(href) + "&maxwidth=" + maxSize[0];
                    }
                    if (maxSize.length > 1 && maxSize[1] != null) {
                        href = String.valueOf(href) + "&maxheight=" + maxSize[1];
                    }
                }
                BasicOEmbed result2 = super.get(href, BasicOEmbed.class);
                result2.setWebmentionUrl(result.getWebmentionUrl());
                result2.setPingbackUrl(result.getPingbackUrl());
                result2.setFaviconUrl(result.getFaviconUrl());
                result = result2;
                continue;
            }
            if ("canonical".equals(rel)) {
                result.setUrl(href);
                continue;
            }
            if (result.getPingbackUrl() == null && "pingback".equals(rel)) {
                result.setPingbackUrl(href);
                continue;
            }
            if (result.getWebmentionUrl() != null || !"webmention".equals(rel)) continue;
            result.setWebmentionUrl(href);
        }
        if (result.getWebmentionUrl() == null && (anchor = doc.body().select("a[rel=webmention][href]").first()) != null) {
            result.setWebmentionUrl(anchor.absUrl("href"));
        }
        return result;
    }

    private void extractPingbackUrl(BasicOEmbed embed, Response response) {
        String h = response.header("X-Pingback");
        if (h != null) {
            embed.setPingbackUrl(h);
        }
    }

    private void extractWebmentionUrl(BasicOEmbed result, Response response) {
        for (String h : response.headers("Link")) {
            try {
                Link link = Link.parse(h);
                if (!link.hasRel("webmention")) continue;
                result.setWebmentionUrl(link.getUri());
                break;
            }
            catch (Exception ignored) {
                System.err.println("Failed to parse Link header: " + h);
            }
        }
    }

    private void loadProviders() throws IOException {
        InputStream in;
        Throwable throwable = null;
        Object var2_4 = null;
        try {
            in = this.getClass().getResourceAsStream("providers.json");
            try {
                this.providers = (List)this.mapper.readValue(in, (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, ProviderInfo.class));
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var2_4 = null;
        try {
            in = this.getClass().getResourceAsStream("extensions.json");
            try {
                Map exts = (Map)this.mapper.readValue(in, (JavaType)this.mapper.getTypeFactory().constructMapType(Map.class, String.class, String.class));
                for (Map.Entry e : exts.entrySet()) {
                    ProviderInfo pi = this.getProviderByName((String)e.getKey());
                    if (pi != null) {
                        for (ProviderEndpoint pe : pi.getEndpoints()) {
                            try {
                                pe.setEmbedClass((String)e.getValue());
                            }
                            catch (ClassNotFoundException cnfe) {
                                System.err.println("Missing extension class " + (String)e.getValue() + ": " + cnfe);
                            }
                        }
                        continue;
                    }
                    System.err.println("Missing provider '" + (String)e.getKey() + "' for extension " + (String)e.getValue());
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private BasicOEmbed photo(BasicOEmbed result, Response response, Integer ... maxSize) throws IOException {
        result.setType("photo");
        SimpleImageInfo info = new SimpleImageInfo(response.peekBody(4096L).bytes());
        result.setWidth(info.getWidth());
        result.setHeight(info.getHeight());
        return result;
    }
}

