/*
 * Decompiled with CFR 0.152.
 */
package com.nmote.oembed;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nmote.oembed.BasicOEmbed;
import com.nmote.oembed.OEmbed;
import com.nmote.oembed.OEmbedProvider;
import com.nmote.oembed.ProviderEndpoint;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public abstract class AbstractOEmbedProvider
implements OEmbedProvider {
    protected final OkHttpClient httpClient;
    protected final ObjectMapper mapper;

    public AbstractOEmbedProvider() {
        this(new OkHttpClient(), new ObjectMapper());
    }

    public AbstractOEmbedProvider(OkHttpClient httpClient, ObjectMapper mapper) {
        Objects.requireNonNull(httpClient);
        Objects.requireNonNull(mapper);
        this.httpClient = httpClient;
        this.mapper = mapper;
    }

    public <T extends OEmbed> T get(String url, Class<T> embedClass) throws IOException {
        Request request = new Request.Builder().url(url).build();
        Response response = this.httpClient.newCall(request).execute();
        if (response.isSuccessful()) {
            Throwable throwable = null;
            Object var6_7 = null;
            try (InputStream in = response.body().byteStream();){
                OEmbed result = (OEmbed)this.mapper.readValue(in, embedClass);
                this.checkEmbedForErrors(result);
                return (T)result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        throw new IOException(String.format("HTTP %d/%s while getting %s", response.code(), response.message(), url));
    }

    @Override
    public OEmbed resolve(String url, Integer ... maxSize) throws IOException {
        ProviderEndpoint provider = this.getProviderEndpointFor(url);
        if (provider == null) {
            throw new IOException("no oEmbed provider endpoint configured for: " + url);
        }
        return this.resolve(url, provider, maxSize);
    }

    public OEmbed resolve(String url, ProviderEndpoint provider, Integer ... maxSize) throws IOException {
        HttpUrl.Builder b = HttpUrl.parse((String)provider.getUrl().replace("{format}", "json")).newBuilder();
        this.prepareRequestURI(b, url, maxSize);
        return this.get(b.toString(), this.getEmbedClass(provider));
    }

    protected void checkEmbedForErrors(OEmbed e) throws IOException {
    }

    protected Class<? extends BasicOEmbed> getEmbedClass(ProviderEndpoint endpoint) {
        return endpoint.embedClass != null ? endpoint.embedClass : BasicOEmbed.class;
    }

    protected abstract ProviderEndpoint getProviderEndpointFor(String var1);

    protected void prepareRequestURI(HttpUrl.Builder builder, String url, Integer ... maxSize) {
        builder.addQueryParameter("url", url);
        builder.addQueryParameter("format", "json");
        if (maxSize != null) {
            if (maxSize.length > 0 && maxSize[0] != null) {
                builder.addQueryParameter("maxwidth", maxSize[0].toString());
            }
            if (maxSize.length > 1 && maxSize[1] != null) {
                builder.addQueryParameter("maxheight", maxSize[1].toString());
            }
        }
        System.out.println(builder);
    }
}

