/*
 * Decompiled with CFR 0.152.
 */
package com.nlocketz.plugins;

import com.google.inject.Injector;
import com.nlocketz.internal.Constants;
import com.nlocketz.internal.EasyPluginPlugin;
import com.nlocketz.internal.MarkedPluginClass;
import com.nlocketz.internal.UserMarkerAnnotation;
import com.nlocketz.internal.Util;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;

public class GuiceEasyPluginPlugin
implements EasyPluginPlugin {
    private static final TypeName INJECTOR_NAME = ClassName.get(Injector.class);

    public void updateRegistry(TypeSpec.Builder registry, UserMarkerAnnotation annotation) {
        MethodSpec injectedWithoutConfig = MethodSpec.methodBuilder((String)("getInjected" + annotation.getServiceInterfaceName() + "ByName")).returns(annotation.getServiceInterfaceTypeName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(String.class, "name", new Modifier[0]).addParameter(INJECTOR_NAME, "injector", new Modifier[0]).beginControlFlow("if (getInstance().$L.containsKey($L))", new Object[]{"pluginMap", "name"}).addStatement("return getInstance().$L.get($L).createInjected($L)", new Object[]{"pluginMap", "name", "injector"}).endControlFlow().addStatement("return null", new Object[0]).build();
        MethodSpec injectedWithConfig = MethodSpec.methodBuilder((String)("getInjected" + annotation.getServiceInterfaceName() + "ByNameWithConfig")).returns(annotation.getServiceInterfaceTypeName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(String.class, "name", new Modifier[0]).addParameter(Constants.CONFIG_TYPE_NAME, "config", new Modifier[0]).addParameter(INJECTOR_NAME, "injector", new Modifier[0]).beginControlFlow("if (getInstance().$L.containsKey($L))", new Object[]{"pluginMap", "name"}).addStatement("return getInstance().$L.get($L).createInjectedWithConfig($L, $L)", new Object[]{"pluginMap", "name", "config", "injector"}).endControlFlow().addStatement("return null", new Object[0]).build();
        registry.addMethod(injectedWithoutConfig);
        registry.addMethod(injectedWithConfig);
    }

    public void updatePluginProvider(TypeSpec.Builder provider, MarkedPluginClass markedPluginClass) {
        MethodSpec injectedWithoutConfig = Util.publicFinalMethod((String)"createInjected", (TypeName)markedPluginClass.getTypeName()).addParameter(INJECTOR_NAME, "injector", new Modifier[0]).addStatement("$T ret = this.create()", new Object[]{markedPluginClass.getTypeName()}).addStatement("$L.injectMembers($L)", new Object[]{"injector", "ret"}).addStatement("return ret", new Object[0]).build();
        MethodSpec injectedWithConfig = Util.publicFinalMethod((String)"createInjectedWithConfig", (TypeName)markedPluginClass.getTypeName()).addParameter(Constants.CONFIG_TYPE_NAME, "config", new Modifier[0]).addParameter(INJECTOR_NAME, "injector", new Modifier[0]).addStatement("$T ret = this.createWithConfig($L)", new Object[]{markedPluginClass.getTypeName(), "config"}).addStatement("$L.injectMembers($L)", new Object[]{"injector", "ret"}).addStatement("return ret", new Object[0]).build();
        provider.addMethod(injectedWithoutConfig);
        provider.addMethod(injectedWithConfig);
    }

    public void updatePluginProviderInterface(TypeSpec.Builder serviceInterface, UserMarkerAnnotation annotation) {
        TypeName returnType = annotation.getServiceInterfaceTypeName();
        MethodSpec createInjected = Util.publicAbstractMethod((String)"createInjected", (TypeName)returnType).addParameter(INJECTOR_NAME, "injector", new Modifier[0]).build();
        MethodSpec createInjectedWithConfig = Util.publicAbstractMethod((String)"createInjectedWithConfig", (TypeName)returnType).addParameter(Constants.CONFIG_TYPE_NAME, "config", new Modifier[0]).addParameter(INJECTOR_NAME, "injector", new Modifier[0]).build();
        serviceInterface.addMethod(createInjected);
        serviceInterface.addMethod(createInjectedWithConfig);
    }
}

