/*
 * Decompiled with CFR 0.152.
 */
package com.ning.metrics.eventtracker;

import com.mogwee.executors.FailsafeScheduledExecutor;
import com.ning.metrics.eventtracker.CollectorController;
import com.ning.metrics.eventtracker.EventType;
import com.ning.metrics.eventtracker.HttpSender;
import com.ning.metrics.serialization.event.EventSerializer;
import com.ning.metrics.serialization.smile.SmileEnvelopeEventSerializer;
import com.ning.metrics.serialization.writer.CallbackHandler;
import com.ning.metrics.serialization.writer.CompressionCodec;
import com.ning.metrics.serialization.writer.DiskSpoolEventWriter;
import com.ning.metrics.serialization.writer.EventHandler;
import com.ning.metrics.serialization.writer.EventWriter;
import com.ning.metrics.serialization.writer.NoCompressionCodec;
import com.ning.metrics.serialization.writer.ObjectOutputEventSerializer;
import com.ning.metrics.serialization.writer.SyncType;
import com.ning.metrics.serialization.writer.ThresholdEventWriter;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;

public class HttpCollectorFactory {
    private static CollectorController singletonController;
    private final CollectorController controller;
    private static HttpSender eventSender;

    public static synchronized CollectorController createHttpController(String collectorHost, int collectorPort, EventType eventType, long httpMaxWaitTimeInMillis, long httpMaxKeepAliveInMillis, String spoolDirectoryName, boolean isFlushEnabled, int flushIntervalInSeconds, SyncType syncType, int syncBatchSize, long maxUncommittedWriteCount, int maxUncommittedPeriodInSeconds, int httpWorkersPoolSize) throws IOException {
        if (singletonController == null) {
            singletonController = new HttpCollectorFactory(collectorHost, collectorPort, eventType, httpMaxWaitTimeInMillis, httpMaxKeepAliveInMillis, spoolDirectoryName, isFlushEnabled, flushIntervalInSeconds, syncType, syncBatchSize, maxUncommittedWriteCount, maxUncommittedPeriodInSeconds, httpWorkersPoolSize).get();
        }
        return singletonController;
    }

    HttpCollectorFactory(String collectorHost, int collectorPort, EventType eventType, long httpMaxWaitTimeInMillis, long httpMaxKeepAliveInMillis, String spoolDirectoryName, boolean isFlushEnabled, int flushIntervalInSeconds, SyncType syncType, int syncBatchSize, long maxUncommittedWriteCount, int maxUncommittedPeriodInSeconds, int httpWorkersPoolSize) {
        eventSender = new HttpSender(collectorHost, collectorPort, eventType, httpMaxWaitTimeInMillis, httpMaxKeepAliveInMillis, httpWorkersPoolSize);
        ObjectOutputEventSerializer serializer = new ObjectOutputEventSerializer();
        switch (eventType) {
            case SMILE: {
                serializer = new SmileEnvelopeEventSerializer(false);
                break;
            }
            case JSON: {
                serializer = new SmileEnvelopeEventSerializer(true);
            }
        }
        DiskSpoolEventWriter eventWriter = new DiskSpoolEventWriter(new EventHandler(){

            public void handle(File file, CallbackHandler handler) {
                eventSender.send(file, handler);
            }
        }, spoolDirectoryName, isFlushEnabled, (long)flushIntervalInSeconds, (ScheduledExecutorService)new FailsafeScheduledExecutor(1, "EventtrackerFlusher"), syncType, syncBatchSize, (CompressionCodec)new NoCompressionCodec(), (EventSerializer)serializer);
        ThresholdEventWriter thresholdEventWriter = new ThresholdEventWriter((EventWriter)eventWriter, maxUncommittedWriteCount, (long)maxUncommittedPeriodInSeconds);
        this.controller = new CollectorController((EventWriter)thresholdEventWriter);
    }

    private CollectorController get() {
        return this.controller;
    }

    public static void shutdown() {
        eventSender.close();
    }
}

