/*
 * Decompiled with CFR 0.152.
 */
package com.ning.maven.plugins.duplicatefinder;

import com.ning.maven.plugins.duplicatefinder.DependencyWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;

public class Exception {
    public static final String CURRENT_PROJECT_IDENTIFIER = "<current project>";
    private DependencyWrapper[] conflictingDependencies;
    private boolean currentProject;
    private Set classes = new HashSet();
    private Set packages = new HashSet();
    private Set resources = new HashSet();
    private Pattern[] matchingResources;

    public void setConflictingDependencies(Dependency[] conflictingDependencies) throws InvalidVersionSpecificationException {
        this.conflictingDependencies = new DependencyWrapper[conflictingDependencies.length];
        for (int idx = 0; idx < conflictingDependencies.length; ++idx) {
            this.conflictingDependencies[idx] = new DependencyWrapper(conflictingDependencies[idx]);
        }
    }

    public void setResourcePatterns(String[] resourcePatterns) {
        this.matchingResources = new Pattern[resourcePatterns.length];
        for (int i = 0; i < resourcePatterns.length; ++i) {
            this.matchingResources[i] = Pattern.compile(resourcePatterns[i], 2);
        }
    }

    public boolean isCurrentProject() {
        return this.currentProject;
    }

    public void setCurrentProject(boolean currentProject) {
        this.currentProject = currentProject;
    }

    public String[] getClasses() {
        return this.classes.toArray(new String[this.classes.size()]);
    }

    public void setClasses(String[] classes) {
        this.classes.addAll(Arrays.asList(classes));
    }

    public String[] getPackages() {
        return this.packages.toArray(new String[this.packages.size()]);
    }

    public void setPackages(String[] packages) {
        this.packages.addAll(Arrays.asList(packages));
    }

    public String[] getResources() {
        return this.resources.toArray(new String[this.resources.size()]);
    }

    public void setResources(String[] resources) {
        this.resources.addAll(Arrays.asList(resources));
    }

    public List getDependencyNames() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.conflictingDependencies != null) {
            for (int idx = 0; idx < this.conflictingDependencies.length; ++idx) {
                result.add(this.conflictingDependencies[idx].toString());
            }
        }
        if (this.currentProject) {
            result.add(CURRENT_PROJECT_IDENTIFIER);
        }
        Collections.sort(result);
        return result;
    }

    public boolean isForArtifacts(Collection artifacts, Artifact projectArtifact) {
        int numMatches = 0;
        Iterator artifactIt = artifacts.iterator();
        while (artifactIt.hasNext()) {
            Artifact artifact = (Artifact)artifactIt.next();
            if (this.conflictingDependencies == null) continue;
            for (int idx = 0; idx < this.conflictingDependencies.length; ++idx) {
                if (this.conflictingDependencies[idx].matches(artifact)) {
                    ++numMatches;
                    continue;
                }
                if (!this.currentProject || !this.currentProjectDependencyMatches(artifact, projectArtifact)) continue;
                ++numMatches;
            }
        }
        return numMatches == artifacts.size();
    }

    private boolean currentProjectDependencyMatches(Artifact artifact, Artifact projectArtifact) {
        Object version;
        VersionRange versionRange = projectArtifact.getVersionRange();
        try {
            version = artifact.getVersionRange() != null ? artifact.getSelectedVersion() : new DefaultArtifactVersion(artifact.getVersion());
        }
        catch (OverConstrainedVersionException ex) {
            return false;
        }
        return StringUtils.equals((String)projectArtifact.getGroupId(), (String)artifact.getGroupId()) && StringUtils.equals((String)projectArtifact.getArtifactId(), (String)artifact.getArtifactId()) && StringUtils.equals((String)StringUtils.defaultIfEmpty((String)projectArtifact.getType(), (String)"jar"), (String)StringUtils.defaultIfEmpty((String)artifact.getType(), (String)"jar")) && StringUtils.equals((String)projectArtifact.getClassifier(), (String)artifact.getClassifier()) && (versionRange != null && versionRange.containsVersion(version) || artifact.getVersion().equals(projectArtifact.getVersion()));
    }

    public boolean containsClass(String className) {
        if (this.classes.contains(className)) {
            return true;
        }
        Iterator pckgNameIt = this.packages.iterator();
        while (pckgNameIt.hasNext()) {
            if (!className.startsWith((String)pckgNameIt.next())) continue;
            return true;
        }
        return false;
    }

    public boolean containsResource(String resource) {
        String resourceAsRelative;
        String string = resourceAsRelative = resource.startsWith("/") || resource.startsWith("\\") ? resource.substring(1) : resource;
        if (this.resources.contains(resourceAsRelative) || this.resources.contains("/" + resourceAsRelative) || this.resources.contains("\\" + resourceAsRelative)) {
            return true;
        }
        for (int i = 0; i < this.matchingResources.length; ++i) {
            if (!this.matchingResources[i].matcher(resourceAsRelative).matches()) continue;
            return true;
        }
        return false;
    }
}

