/*
 * Decompiled with CFR 0.152.
 */
package com.ning.maven.plugins.duplicatefinder;

import com.ning.maven.plugins.duplicatefinder.ClasspathDescriptor;
import com.ning.maven.plugins.duplicatefinder.DependencyWrapper;
import com.ning.maven.plugins.duplicatefinder.Exception;
import com.ning.maven.plugins.duplicatefinder.ToStringComparator;
import com.pyx4j.log4j.MavenLogAppender;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateFinderMojo
extends AbstractMojo {
    protected final Logger LOG = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final int NO_CONFLICT = 0;
    private static final int CONFLICT_CONTENT_EQUAL = 1;
    private static final int CONFLICT_CONTENT_DIFFERENT = 2;
    private MavenProject project;
    private boolean printEqualFiles = false;
    private boolean failBuildInCaseOfDifferentContentConflict;
    private boolean failBuildInCaseOfEqualContentConflict;
    private boolean failBuildInCaseOfConflict;
    private boolean useDefaultResourceIgnoreList = true;
    private String[] ignoredResources;
    private Exception[] exceptions;
    private DependencyWrapper[] ignoredDependencies;
    private boolean checkCompileClasspath = true;
    private boolean checkRuntimeClasspath = true;
    private boolean checkTestClasspath = true;
    protected boolean skip = false;

    public void setIgnoredDependencies(Dependency[] ignoredDependencies) throws InvalidVersionSpecificationException {
        this.ignoredDependencies = new DependencyWrapper[ignoredDependencies.length];
        for (int idx = 0; idx < ignoredDependencies.length; ++idx) {
            this.ignoredDependencies[idx] = new DependencyWrapper(ignoredDependencies[idx]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        MavenLogAppender.startPluginLog((AbstractMojo)this);
        try {
            if (this.skip) {
                this.LOG.debug("Skipping execution!");
            } else {
                if (this.checkCompileClasspath) {
                    this.checkCompileClasspath();
                }
                if (this.checkRuntimeClasspath) {
                    this.checkRuntimeClasspath();
                }
                if (this.checkTestClasspath) {
                    this.checkTestClasspath();
                }
            }
        }
        finally {
            MavenLogAppender.endPluginLog((AbstractMojo)this);
        }
    }

    private void checkCompileClasspath() throws MojoExecutionException {
        try {
            this.LOG.info("Checking compile classpath");
            Map artifactsByFile = this.createArtifactsByFileMap(this.project.getCompileArtifacts());
            this.addOutputDirectory(artifactsByFile);
            this.checkClasspath(this.project.getCompileClasspathElements(), artifactsByFile);
        }
        catch (DependencyResolutionRequiredException ex) {
            throw new MojoExecutionException("Could not resolve dependencies", (java.lang.Exception)((Object)ex));
        }
    }

    private void checkRuntimeClasspath() throws MojoExecutionException {
        try {
            this.LOG.info("Checking runtime classpath");
            Map artifactsByFile = this.createArtifactsByFileMap(this.project.getRuntimeArtifacts());
            this.addOutputDirectory(artifactsByFile);
            this.checkClasspath(this.project.getRuntimeClasspathElements(), artifactsByFile);
        }
        catch (DependencyResolutionRequiredException ex) {
            throw new MojoExecutionException("Could not resolve dependencies", (java.lang.Exception)((Object)ex));
        }
    }

    private void checkTestClasspath() throws MojoExecutionException {
        try {
            this.LOG.info("Checking test classpath");
            Map artifactsByFile = this.createArtifactsByFileMap(this.project.getTestArtifacts());
            this.addOutputDirectory(artifactsByFile);
            this.addTestOutputDirectory(artifactsByFile);
            this.checkClasspath(this.project.getTestClasspathElements(), artifactsByFile);
        }
        catch (DependencyResolutionRequiredException ex) {
            throw new MojoExecutionException("Could not resolve dependencies", (java.lang.Exception)((Object)ex));
        }
    }

    private void checkClasspath(List classpathElements, Map artifactsByFile) throws MojoExecutionException {
        ClasspathDescriptor classpathDesc = this.createClasspathDescriptor(classpathElements);
        int foundDuplicateClassesConflict = this.checkForDuplicateClasses(classpathDesc, artifactsByFile);
        int foundDuplicateResourcesConflict = this.checkForDuplicateResources(classpathDesc, artifactsByFile);
        int maxConflict = Math.max(foundDuplicateClassesConflict, foundDuplicateResourcesConflict);
        if (this.failBuildInCaseOfConflict && maxConflict > 0 || this.failBuildInCaseOfDifferentContentConflict && maxConflict == 2 || this.failBuildInCaseOfEqualContentConflict && maxConflict >= 1) {
            throw new MojoExecutionException("Found duplicate classes/resources");
        }
    }

    private int checkForDuplicateClasses(ClasspathDescriptor classpathDesc, Map artifactsByFile) throws MojoExecutionException {
        TreeMap classDifferentConflictsByArtifactNames = new TreeMap(new ToStringComparator());
        TreeMap<String, ArrayList<String>> classEqualConflictsByArtifactNames = new TreeMap<String, ArrayList<String>>(new ToStringComparator());
        Iterator classNameIt = classpathDesc.getClasss().iterator();
        while (classNameIt.hasNext()) {
            String artifactNames;
            String className = (String)classNameIt.next();
            Set elements = classpathDesc.getElementsHavingClass(className);
            if (elements.size() <= 1) continue;
            Set artifacts = this.getArtifactsForElements(elements, artifactsByFile);
            this.filterIgnoredDependencies(artifacts);
            if (artifacts.size() < 2 || this.isExceptedClass(className, artifacts)) continue;
            TreeMap<String, ArrayList<String>> conflictsByArtifactNames = this.isAllElementsAreEqual(elements, className.replace('.', '/') + ".class") ? classEqualConflictsByArtifactNames : classDifferentConflictsByArtifactNames;
            ArrayList<String> classNames = (ArrayList<String>)conflictsByArtifactNames.get(artifactNames = this.getArtifactsToString(artifacts));
            if (classNames == null) {
                classNames = new ArrayList<String>();
                conflictsByArtifactNames.put(artifactNames, classNames);
            }
            classNames.add(className);
        }
        int conflict = 0;
        if (!classEqualConflictsByArtifactNames.isEmpty()) {
            if (this.printEqualFiles || this.failBuildInCaseOfConflict || this.failBuildInCaseOfEqualContentConflict) {
                this.printWarningMessage(classEqualConflictsByArtifactNames, "(but equal)", "classes");
            }
            conflict = 1;
        }
        if (!classDifferentConflictsByArtifactNames.isEmpty()) {
            this.printWarningMessage(classDifferentConflictsByArtifactNames, "and different", "classes");
            conflict = 2;
        }
        return conflict;
    }

    private int checkForDuplicateResources(ClasspathDescriptor classpathDesc, Map artifactsByFile) throws MojoExecutionException {
        TreeMap resourceDifferentConflictsByArtifactNames = new TreeMap(new ToStringComparator());
        TreeMap<String, ArrayList<String>> resourceEqualConflictsByArtifactNames = new TreeMap<String, ArrayList<String>>(new ToStringComparator());
        Iterator resourceIt = classpathDesc.getResources().iterator();
        while (resourceIt.hasNext()) {
            String artifactNames;
            String resource = (String)resourceIt.next();
            Set elements = classpathDesc.getElementsHavingResource(resource);
            if (elements.size() <= 1) continue;
            Set artifacts = this.getArtifactsForElements(elements, artifactsByFile);
            this.filterIgnoredDependencies(artifacts);
            if (artifacts.size() < 2 || this.isExceptedResource(resource, artifacts)) continue;
            TreeMap<String, ArrayList<String>> conflictsByArtifactNames = this.isAllElementsAreEqual(elements, resource) ? resourceEqualConflictsByArtifactNames : resourceDifferentConflictsByArtifactNames;
            ArrayList<String> resources = (ArrayList<String>)conflictsByArtifactNames.get(artifactNames = this.getArtifactsToString(artifacts));
            if (resources == null) {
                resources = new ArrayList<String>();
                conflictsByArtifactNames.put(artifactNames, resources);
            }
            resources.add(resource);
        }
        int conflict = 0;
        if (!resourceEqualConflictsByArtifactNames.isEmpty()) {
            if (this.printEqualFiles || this.failBuildInCaseOfConflict || this.failBuildInCaseOfEqualContentConflict) {
                this.printWarningMessage(resourceEqualConflictsByArtifactNames, "(but equal)", "resources");
            }
            return 1;
        }
        if (!resourceDifferentConflictsByArtifactNames.isEmpty()) {
            this.printWarningMessage(resourceDifferentConflictsByArtifactNames, "and different", "resources");
            conflict = 2;
        }
        return conflict;
    }

    private void printWarningMessage(Map conflictsByArtifactNames, String hint, String type) {
        Iterator conflictIt = conflictsByArtifactNames.entrySet().iterator();
        while (conflictIt.hasNext()) {
            Map.Entry entry = conflictIt.next();
            String artifactNames = (String)entry.getKey();
            List classNames = (List)entry.getValue();
            this.LOG.warn("Found duplicate " + hint + " " + type + " in " + artifactNames + " :");
            Iterator classNameIt = classNames.iterator();
            while (classNameIt.hasNext()) {
                this.LOG.warn("  " + classNameIt.next());
            }
        }
    }

    private boolean isAllElementsAreEqual(Set elements, String resourcePath) {
        File firstFile = null;
        String firstSHA256 = null;
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            File file = (File)it.next();
            try {
                String newSHA256 = this.getSHA256HexOfElement(file, resourcePath);
                if (firstSHA256 == null) {
                    firstSHA256 = newSHA256;
                    firstFile = file;
                    continue;
                }
                if (newSHA256.equals(firstSHA256)) continue;
                this.LOG.debug("Found different SHA256 hashs for elements " + resourcePath + " in file " + firstFile + " and " + file);
                return false;
            }
            catch (IOException ex) {
                this.LOG.warn("Could not read content from file " + file + "!", (Throwable)ex);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSHA256HexOfElement(File file, String resourcePath) throws IOException {
        InputStream in;
        if (file.isDirectory()) {
            File resourceFile = new File(file, resourcePath);
            in = new BufferedInputStream(new FileInputStream(resourceFile));
        } else {
            ZipFile zip = new ZipFile(file);
            ZipEntry zipEntry = zip.getEntry(resourcePath);
            if (zipEntry == null) {
                throw new IOException("Could not find " + resourcePath + " in archive " + file);
            }
            in = zip.getInputStream(zipEntry);
        }
        try {
            String string = DigestUtils.sha256Hex((InputStream)in);
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    private void filterIgnoredDependencies(Set artifacts) {
        if (this.ignoredDependencies != null) {
            for (int idx = 0; idx < this.ignoredDependencies.length; ++idx) {
                Iterator artifactIt = artifacts.iterator();
                while (artifactIt.hasNext()) {
                    Artifact artifact = (Artifact)artifactIt.next();
                    if (!this.ignoredDependencies[idx].matches(artifact)) continue;
                    artifactIt.remove();
                }
            }
        }
    }

    private boolean isExceptedClass(String className, Collection artifacts) {
        List exceptions = this.getExceptionsFor(artifacts);
        Iterator it = exceptions.iterator();
        while (it.hasNext()) {
            Exception exception = (Exception)it.next();
            if (!exception.containsClass(className)) continue;
            return true;
        }
        return false;
    }

    private boolean isExceptedResource(String resource, Collection artifacts) {
        List exceptions = this.getExceptionsFor(artifacts);
        Iterator it = exceptions.iterator();
        while (it.hasNext()) {
            Exception exception = (Exception)it.next();
            if (!exception.containsResource(resource)) continue;
            return true;
        }
        return false;
    }

    private List getExceptionsFor(Collection artifacts) {
        ArrayList<Exception> result = new ArrayList<Exception>();
        if (this.exceptions != null) {
            for (int idx = 0; idx < this.exceptions.length; ++idx) {
                if (!this.exceptions[idx].isForArtifacts(artifacts, this.project.getArtifact())) continue;
                result.add(this.exceptions[idx]);
            }
        }
        return result;
    }

    private Set getArtifactsForElements(Collection elements, Map artifactsByFile) {
        TreeSet<Artifact> artifacts = new TreeSet<Artifact>();
        Iterator elementUrlIt = elements.iterator();
        while (elementUrlIt.hasNext()) {
            File element = (File)elementUrlIt.next();
            Artifact artifact = (Artifact)artifactsByFile.get(element);
            if (artifact == null) {
                artifact = this.project.getArtifact();
            }
            artifacts.add(artifact);
        }
        return artifacts;
    }

    private String getArtifactsToString(Collection artifacts) {
        StringBuffer result = new StringBuffer();
        result.append("[");
        Iterator it = artifacts.iterator();
        while (it.hasNext()) {
            if (result.length() > 1) {
                result.append(",");
            }
            result.append(this.getQualifiedName((Artifact)it.next()));
        }
        result.append("]");
        return result.toString();
    }

    private ClasspathDescriptor createClasspathDescriptor(List classpathElements) throws MojoExecutionException {
        ClasspathDescriptor classpathDesc = new ClasspathDescriptor();
        classpathDesc.setUseDefaultResourceIgnoreList(this.useDefaultResourceIgnoreList);
        classpathDesc.setIgnoredResources(this.ignoredResources);
        Iterator elementIt = classpathElements.iterator();
        while (elementIt.hasNext()) {
            String element = (String)elementIt.next();
            try {
                classpathDesc.add(new File(element));
            }
            catch (FileNotFoundException ex) {
                this.LOG.debug("Could not access classpath element " + element);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Error trying to access element " + element, (java.lang.Exception)ex);
            }
        }
        return classpathDesc;
    }

    private Map createArtifactsByFileMap(List artifacts) throws DependencyResolutionRequiredException {
        HashMap<File, Artifact> artifactsByFile = new HashMap<File, Artifact>(artifacts.size());
        Iterator artifactIt = artifacts.iterator();
        while (artifactIt.hasNext()) {
            Artifact artifact = (Artifact)artifactIt.next();
            File localPath = this.getLocalProjectPath(artifact);
            File repoPath = artifact.getFile();
            if (localPath == null && repoPath == null) {
                throw new DependencyResolutionRequiredException(artifact);
            }
            if (localPath != null) {
                artifactsByFile.put(localPath, artifact);
            }
            if (repoPath == null) continue;
            artifactsByFile.put(repoPath, artifact);
        }
        return artifactsByFile;
    }

    private File getLocalProjectPath(Artifact artifact) throws DependencyResolutionRequiredException {
        String refId = artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion();
        MavenProject owningProject = (MavenProject)this.project.getProjectReferences().get(refId);
        if (owningProject != null) {
            if (artifact.getType().equals("test-jar")) {
                File testOutputDir = new File(owningProject.getBuild().getTestOutputDirectory());
                if (testOutputDir.exists()) {
                    return testOutputDir;
                }
            } else {
                return new File(this.project.getBuild().getOutputDirectory());
            }
        }
        return null;
    }

    private void addOutputDirectory(Map artifactsByFile) {
        File outputDir = new File(this.project.getBuild().getOutputDirectory());
        if (outputDir.exists()) {
            artifactsByFile.put(outputDir, null);
        }
    }

    private void addTestOutputDirectory(Map artifactsByFile) {
        File outputDir = new File(this.project.getBuild().getOutputDirectory());
        if (outputDir.exists()) {
            artifactsByFile.put(outputDir, null);
        }
    }

    private String getQualifiedName(Artifact artifact) {
        String result = artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion();
        if (artifact.getType() != null && !"jar".equals(artifact.getType())) {
            result = result + ":" + artifact.getType();
        }
        if (!(artifact.getClassifier() == null || "tests".equals(artifact.getClassifier()) && "test-jar".equals(artifact.getType()))) {
            result = result + ":" + artifact.getClassifier();
        }
        return result;
    }
}

