/*
 * Decompiled with CFR 0.152.
 */
package com.ning.maven.plugins.duplicatefinder;

import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;

public class DependencyWrapper {
    private final Dependency dependency;
    private final VersionRange versionRange;

    public DependencyWrapper(Dependency dependency) throws InvalidVersionSpecificationException {
        this.dependency = dependency;
        this.versionRange = VersionRange.createFromVersionSpec((String)dependency.getVersion());
    }

    public String toString() {
        String result = this.dependency.getGroupId() + ":" + this.dependency.getArtifactId() + ":" + this.dependency.getVersion();
        if (this.dependency.getType() != null && !"jar".equals(this.dependency.getType())) {
            result = result + ":" + this.dependency.getType();
        }
        if (!(this.dependency.getClassifier() == null || "tests".equals(this.dependency.getClassifier()) && "test-jar".equals(this.dependency.getType()))) {
            result = result + ":" + this.dependency.getClassifier();
        }
        return result;
    }

    public boolean matches(Artifact artifact) {
        Object version = null;
        try {
            version = artifact.getVersionRange() != null ? artifact.getSelectedVersion() : new DefaultArtifactVersion(artifact.getVersion());
        }
        catch (OverConstrainedVersionException ex) {
            return false;
        }
        return StringUtils.equals((String)this.dependency.getGroupId(), (String)artifact.getGroupId()) && StringUtils.equals((String)this.dependency.getArtifactId(), (String)artifact.getArtifactId()) && StringUtils.equals((String)StringUtils.defaultIfEmpty((String)this.dependency.getType(), (String)"jar"), (String)StringUtils.defaultIfEmpty((String)artifact.getType(), (String)"jar")) && StringUtils.equals((String)this.dependency.getClassifier(), (String)artifact.getClassifier()) && (this.versionRange == null || this.versionRange.containsVersion(version) || StringUtils.equals((String)artifact.getVersion(), (String)this.dependency.getVersion()));
    }
}

