/*
 * Decompiled with CFR 0.152.
 */
package com.ning.maven.plugins.duplicatefinder;

import com.ning.maven.plugins.duplicatefinder.ClasspathDescriptor;
import com.ning.maven.plugins.duplicatefinder.DependencyWrapper;
import com.ning.maven.plugins.duplicatefinder.Exception;
import com.ning.maven.plugins.duplicatefinder.ToStringComparator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class DuplicateFinderMojo
extends AbstractMojo {
    private MavenProject project;
    private boolean failBuildInCaseOfConflict;
    private boolean useDefaultResourceIgnoreList = true;
    private String[] ignoredResources;
    private Exception[] exceptions;
    private DependencyWrapper[] ignoredDependencies;

    public void setIgnoredDependencies(Dependency[] ignoredDependencies) throws InvalidVersionSpecificationException {
        this.ignoredDependencies = new DependencyWrapper[ignoredDependencies.length];
        for (int idx = 0; idx < ignoredDependencies.length; ++idx) {
            this.ignoredDependencies[idx] = new DependencyWrapper(ignoredDependencies[idx]);
        }
    }

    public void execute() throws MojoExecutionException {
        this.checkCompileClasspath();
        this.checkRuntimeClasspath();
        this.checkTestClasspath();
    }

    private void checkCompileClasspath() throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)"Checking compile classpath");
            Map artifactsByFile = this.createArtifactsByFileMap(this.project.getCompileArtifacts());
            this.addOutputDirectory(artifactsByFile);
            this.checkClasspath(this.project.getCompileClasspathElements(), artifactsByFile);
        }
        catch (DependencyResolutionRequiredException ex) {
            throw new MojoExecutionException("Could not resolve dependencies", (java.lang.Exception)((Object)ex));
        }
    }

    private void checkRuntimeClasspath() throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)"Checking runtime classpath");
            Map artifactsByFile = this.createArtifactsByFileMap(this.project.getRuntimeArtifacts());
            this.addOutputDirectory(artifactsByFile);
            this.checkClasspath(this.project.getRuntimeClasspathElements(), artifactsByFile);
        }
        catch (DependencyResolutionRequiredException ex) {
            throw new MojoExecutionException("Could not resolve dependencies", (java.lang.Exception)((Object)ex));
        }
    }

    private void checkTestClasspath() throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)"Checking test classpath");
            Map artifactsByFile = this.createArtifactsByFileMap(this.project.getTestArtifacts());
            this.addOutputDirectory(artifactsByFile);
            this.addTestOutputDirectory(artifactsByFile);
            this.checkClasspath(this.project.getTestClasspathElements(), artifactsByFile);
        }
        catch (DependencyResolutionRequiredException ex) {
            throw new MojoExecutionException("Could not resolve dependencies", (java.lang.Exception)((Object)ex));
        }
    }

    private void checkClasspath(List classpathElements, Map artifactsByFile) throws MojoExecutionException {
        ClasspathDescriptor classpathDesc = this.createClasspathDescriptor(classpathElements);
        boolean foundDuplicateClasses = this.checkForDuplicateClasses(classpathDesc, artifactsByFile);
        boolean foundDuplicateResources = this.checkForDuplicateResources(classpathDesc, artifactsByFile);
        if (this.failBuildInCaseOfConflict && (foundDuplicateClasses || foundDuplicateResources)) {
            throw new MojoExecutionException("Found duplicate classes/resources");
        }
    }

    private boolean checkForDuplicateClasses(ClasspathDescriptor classpathDesc, Map artifactsByFile) throws MojoExecutionException {
        TreeMap<String, ArrayList<String>> conflictsByArtifactNames = new TreeMap<String, ArrayList<String>>(new ToStringComparator());
        Iterator classNameIt = classpathDesc.getClasss().iterator();
        while (classNameIt.hasNext()) {
            String className = (String)classNameIt.next();
            Set elements = classpathDesc.getElementsHavingClass(className);
            if (elements.size() <= 1) continue;
            Set artifacts = this.getArtifactsForElements(elements, artifactsByFile);
            this.filterIgnoredDependencies(artifacts);
            if (artifacts.size() < 2 || this.isExceptedClass(className, artifacts)) continue;
            String artifactNames = this.getArtifactsToString(artifacts);
            ArrayList<String> classNames = (ArrayList<String>)conflictsByArtifactNames.get(artifactNames);
            if (classNames == null) {
                classNames = new ArrayList<String>();
                conflictsByArtifactNames.put(artifactNames, classNames);
            }
            classNames.add(className);
        }
        if (!conflictsByArtifactNames.isEmpty()) {
            Iterator conflictIt = conflictsByArtifactNames.entrySet().iterator();
            while (conflictIt.hasNext()) {
                Map.Entry entry = conflictIt.next();
                String artifactNames = (String)entry.getKey();
                List classNames = (List)entry.getValue();
                this.getLog().warn((CharSequence)("Found duplicate classes in " + artifactNames + " :"));
                Iterator classNameIt2 = classNames.iterator();
                while (classNameIt2.hasNext()) {
                    this.getLog().warn((CharSequence)("  " + classNameIt2.next()));
                }
            }
            return true;
        }
        return false;
    }

    private boolean checkForDuplicateResources(ClasspathDescriptor classpathDesc, Map artifactsByFile) throws MojoExecutionException {
        TreeMap<String, ArrayList<String>> conflictsByArtifactNames = new TreeMap<String, ArrayList<String>>(new ToStringComparator());
        Iterator resourceIt = classpathDesc.getResources().iterator();
        while (resourceIt.hasNext()) {
            String resource = (String)resourceIt.next();
            Set elements = classpathDesc.getElementsHavingResource(resource);
            if (elements.size() <= 1) continue;
            Set artifacts = this.getArtifactsForElements(elements, artifactsByFile);
            this.filterIgnoredDependencies(artifacts);
            if (artifacts.size() < 2 || this.isExceptedResource(resource, artifacts)) continue;
            String artifactNames = this.getArtifactsToString(artifacts);
            ArrayList<String> resources = (ArrayList<String>)conflictsByArtifactNames.get(artifactNames);
            if (resources == null) {
                resources = new ArrayList<String>();
                conflictsByArtifactNames.put(artifactNames, resources);
            }
            resources.add(resource);
        }
        if (!conflictsByArtifactNames.isEmpty()) {
            Iterator conflictIt = conflictsByArtifactNames.entrySet().iterator();
            while (conflictIt.hasNext()) {
                Map.Entry entry = conflictIt.next();
                String artifactNames = (String)entry.getKey();
                List resources = (List)entry.getValue();
                this.getLog().warn((CharSequence)("Found duplicate resources in " + artifactNames + " :"));
                Iterator resourceIt2 = resources.iterator();
                while (resourceIt2.hasNext()) {
                    this.getLog().warn((CharSequence)("  " + resourceIt2.next()));
                }
            }
            return true;
        }
        return false;
    }

    private void filterIgnoredDependencies(Set artifacts) {
        if (this.ignoredDependencies != null) {
            for (int idx = 0; idx < this.ignoredDependencies.length; ++idx) {
                Iterator artifactIt = artifacts.iterator();
                while (artifactIt.hasNext()) {
                    Artifact artifact = (Artifact)artifactIt.next();
                    if (!this.ignoredDependencies[idx].matches(artifact)) continue;
                    artifactIt.remove();
                }
            }
        }
    }

    private boolean isExceptedClass(String className, Collection artifacts) {
        List exceptions = this.getExceptionsFor(artifacts);
        Iterator it = exceptions.iterator();
        while (it.hasNext()) {
            Exception exception = (Exception)it.next();
            if (!exception.containsClass(className)) continue;
            return true;
        }
        return false;
    }

    private boolean isExceptedResource(String resource, Collection artifacts) {
        List exceptions = this.getExceptionsFor(artifacts);
        Iterator it = exceptions.iterator();
        while (it.hasNext()) {
            Exception exception = (Exception)it.next();
            if (!exception.containsResource(resource)) continue;
            return true;
        }
        return false;
    }

    private List getExceptionsFor(Collection artifacts) {
        ArrayList<Exception> result = new ArrayList<Exception>();
        if (this.exceptions != null) {
            for (int idx = 0; idx < this.exceptions.length; ++idx) {
                if (!this.exceptions[idx].isForArtifacts(artifacts, this.project.getArtifact())) continue;
                result.add(this.exceptions[idx]);
            }
        }
        return result;
    }

    private Set getArtifactsForElements(Collection elements, Map artifactsByFile) {
        TreeSet<Artifact> artifacts = new TreeSet<Artifact>();
        Iterator elementUrlIt = elements.iterator();
        while (elementUrlIt.hasNext()) {
            File element = (File)elementUrlIt.next();
            Artifact artifact = (Artifact)artifactsByFile.get(element);
            if (artifact == null) {
                artifact = this.project.getArtifact();
            }
            artifacts.add(artifact);
        }
        return artifacts;
    }

    private String getArtifactsToString(Collection artifacts) {
        StringBuffer result = new StringBuffer();
        result.append("[");
        Iterator it = artifacts.iterator();
        while (it.hasNext()) {
            if (result.length() > 1) {
                result.append(",");
            }
            result.append(this.getQualifiedName((Artifact)it.next()));
        }
        result.append("]");
        return result.toString();
    }

    private ClasspathDescriptor createClasspathDescriptor(List classpathElements) throws MojoExecutionException {
        ClasspathDescriptor classpathDesc = new ClasspathDescriptor();
        classpathDesc.setUseDefaultResourceIgnoreList(this.useDefaultResourceIgnoreList);
        classpathDesc.setIgnoredResources(this.ignoredResources);
        Iterator elementIt = classpathElements.iterator();
        while (elementIt.hasNext()) {
            String element = (String)elementIt.next();
            try {
                classpathDesc.add(new File(element));
            }
            catch (FileNotFoundException ex) {
                this.getLog().debug((CharSequence)("Could not access classpath element " + element));
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Error trying to access element " + element, (java.lang.Exception)ex);
            }
        }
        return classpathDesc;
    }

    private Map createArtifactsByFileMap(List artifacts) throws DependencyResolutionRequiredException {
        HashMap<File, Artifact> artifactsByFile = new HashMap<File, Artifact>(artifacts.size());
        Iterator artifactIt = artifacts.iterator();
        while (artifactIt.hasNext()) {
            Artifact artifact = (Artifact)artifactIt.next();
            File localPath = this.getLocalProjectPath(artifact);
            File repoPath = artifact.getFile();
            if (localPath == null && repoPath == null) {
                throw new DependencyResolutionRequiredException(artifact);
            }
            if (localPath != null) {
                artifactsByFile.put(localPath, artifact);
            }
            if (repoPath == null) continue;
            artifactsByFile.put(repoPath, artifact);
        }
        return artifactsByFile;
    }

    private File getLocalProjectPath(Artifact artifact) throws DependencyResolutionRequiredException {
        String refId = artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion();
        MavenProject owningProject = (MavenProject)this.project.getProjectReferences().get(refId);
        if (owningProject != null) {
            if (artifact.getType().equals("test-jar")) {
                File testOutputDir = new File(owningProject.getBuild().getTestOutputDirectory());
                if (testOutputDir.exists()) {
                    return testOutputDir;
                }
            } else {
                return new File(this.project.getBuild().getOutputDirectory());
            }
        }
        return null;
    }

    private void addOutputDirectory(Map artifactsByFile) {
        File outputDir = new File(this.project.getBuild().getOutputDirectory());
        if (outputDir.exists()) {
            artifactsByFile.put(outputDir, null);
        }
    }

    private void addTestOutputDirectory(Map artifactsByFile) {
        File outputDir = new File(this.project.getBuild().getOutputDirectory());
        if (outputDir.exists()) {
            artifactsByFile.put(outputDir, null);
        }
    }

    private String getQualifiedName(Artifact artifact) {
        String result = artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion();
        if (artifact.getType() != null && !"jar".equals(artifact.getType())) {
            result = result + ":" + artifact.getType();
        }
        if (!(artifact.getClassifier() == null || "tests".equals(artifact.getClassifier()) && "test-jar".equals(artifact.getType()))) {
            result = result + ":" + artifact.getClassifier();
        }
        return result;
    }
}

