/*
 * Decompiled with CFR 0.152.
 */
package com.ning.compress.lzf.impl;

import com.ning.compress.BufferRecycler;
import com.ning.compress.lzf.ChunkEncoder;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

public abstract class UnsafeChunkEncoder
extends ChunkEncoder {
    static final Unsafe unsafe;
    static final long BYTE_ARRAY_OFFSET;

    UnsafeChunkEncoder(int totalLength) {
        super(totalLength);
    }

    UnsafeChunkEncoder(int totalLength, boolean bogus) {
        super(totalLength, bogus);
    }

    UnsafeChunkEncoder(int totalLength, BufferRecycler bufferRecycler) {
        super(totalLength, bufferRecycler);
    }

    UnsafeChunkEncoder(int totalLength, BufferRecycler bufferRecycler, boolean bogus) {
        super(totalLength, bufferRecycler, bogus);
    }

    static void _checkArrayIndices(byte[] array, int start, int end) {
        if (start < 0 || end < start || end > array.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    static void _checkOutputLength(int inputLen, int outputLen) {
        int maxEncoded = inputLen + (inputLen + 31 >> 5);
        if (maxEncoded < 0 || maxEncoded > outputLen) {
            throw new IllegalArgumentException("Output length " + outputLen + " is too small for input length " + inputLen);
        }
    }

    static final int _copyPartialLiterals(byte[] in, int inPos, byte[] out, int outPos, int literals) {
        if (out.length - outPos < literals + 1) {
            throw new IllegalArgumentException("Not enough space in output array");
        }
        out[outPos++] = (byte)(literals - 1);
        long rawInPtr = BYTE_ARRAY_OFFSET + (long)inPos - (long)literals;
        long rawOutPtr = BYTE_ARRAY_OFFSET + (long)outPos;
        switch (literals >> 3) {
            case 3: {
                unsafe.putLong(out, rawOutPtr, unsafe.getLong(in, rawInPtr));
                rawInPtr += 8L;
                rawOutPtr += 8L;
            }
            case 2: {
                unsafe.putLong(out, rawOutPtr, unsafe.getLong(in, rawInPtr));
                rawInPtr += 8L;
                rawOutPtr += 8L;
            }
            case 1: {
                unsafe.putLong(out, rawOutPtr, unsafe.getLong(in, rawInPtr));
                rawInPtr += 8L;
                rawOutPtr += 8L;
            }
        }
        int left = literals & 7;
        if (left > 0) {
            System.arraycopy(in, (int)(rawInPtr - BYTE_ARRAY_OFFSET), out, (int)(rawOutPtr - BYTE_ARRAY_OFFSET), left);
        }
        return outPos + literals;
    }

    static final int _copyLongLiterals(byte[] in, int inPos, byte[] out, int outPos, int literals) {
        long rawInPtr = BYTE_ARRAY_OFFSET + (long)(inPos -= literals);
        long rawOutPtr = BYTE_ARRAY_OFFSET + (long)outPos;
        while (literals >= 32) {
            out[outPos++] = 31;
            unsafe.putLong(out, ++rawOutPtr, unsafe.getLong(in, rawInPtr));
            unsafe.putLong(out, rawOutPtr += 8L, unsafe.getLong(in, rawInPtr += 8L));
            unsafe.putLong(out, rawOutPtr += 8L, unsafe.getLong(in, rawInPtr += 8L));
            unsafe.putLong(out, rawOutPtr += 8L, unsafe.getLong(in, rawInPtr += 8L));
            rawInPtr += 8L;
            rawOutPtr += 8L;
            inPos += 32;
            outPos += 32;
            literals -= 32;
        }
        if (literals > 0) {
            return UnsafeChunkEncoder._copyPartialLiterals(in, inPos + literals, out, outPos, literals);
        }
        return outPos;
    }

    static final int _copyFullLiterals(byte[] in, int inPos, byte[] out, int outPos) {
        if (out.length - outPos < 33) {
            throw new IllegalArgumentException("Not enough space in output array");
        }
        out[outPos++] = 31;
        long rawInPtr = BYTE_ARRAY_OFFSET + (long)inPos - 32L;
        long rawOutPtr = BYTE_ARRAY_OFFSET + (long)outPos;
        unsafe.putLong(out, rawOutPtr, unsafe.getLong(in, rawInPtr));
        unsafe.putLong(out, rawOutPtr += 8L, unsafe.getLong(in, rawInPtr += 8L));
        unsafe.putLong(out, rawOutPtr += 8L, unsafe.getLong(in, rawInPtr += 8L));
        unsafe.putLong(out, rawOutPtr += 8L, unsafe.getLong(in, rawInPtr += 8L));
        return outPos + 32;
    }

    static final int _handleTail(byte[] in, int inPos, int inEnd, byte[] out, int outPos, int literals) {
        while (inPos < inEnd) {
            ++inPos;
            if (++literals != 32) continue;
            out[outPos++] = (byte)(literals - 1);
            System.arraycopy(in, inPos - literals, out, outPos, literals);
            outPos += literals;
            literals = 0;
        }
        if (literals > 0) {
            out[outPos++] = (byte)(literals - 1);
            System.arraycopy(in, inPos - literals, out, outPos, literals);
            outPos += literals;
        }
        return outPos;
    }

    static final int _findTailMatchLength(byte[] in, int ptr1, int ptr2, int maxPtr1) {
        int start1 = ptr1;
        while (ptr1 < maxPtr1 && in[ptr1] == in[ptr2]) {
            ++ptr1;
            ++ptr2;
        }
        return ptr1 - start1 + 1;
    }

    static {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            unsafe = (Unsafe)theUnsafe.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        BYTE_ARRAY_OFFSET = unsafe.arrayBaseOffset(byte[].class);
    }
}

