/*
 * Decompiled with CFR 0.152.
 */
package com.ning.compress.lzf.impl;

import com.ning.compress.lzf.impl.UnsafeChunkEncoder;

public class UnsafeChunkEncoderLE
extends UnsafeChunkEncoder {
    public UnsafeChunkEncoderLE(int totalLength) {
        super(totalLength);
    }

    public UnsafeChunkEncoderLE(int totalLength, boolean bogus) {
        super(totalLength, bogus);
    }

    @Override
    protected int tryCompress(byte[] in, int inPos, int inEnd, byte[] out, int outPos) {
        int[] hashTable = this._hashTable;
        int literals = 0;
        inEnd -= 4;
        int firstPos = inPos;
        int seen = UnsafeChunkEncoderLE._getInt(in, inPos) >> 16;
        while (inPos < inEnd) {
            seen = (seen << 8) + (in[inPos + 2] & 0xFF);
            int off = this.hash(seen);
            int ref = hashTable[off];
            hashTable[off] = inPos;
            if (ref >= inPos || ref < firstPos || (off = inPos - ref) > 8192 || seen << 8 != UnsafeChunkEncoderLE._getInt(in, ref - 1) << 8) {
                ++inPos;
                if (++literals != 32) continue;
                outPos = UnsafeChunkEncoderLE._copyFullLiterals(in, inPos, out, outPos);
                literals = 0;
                continue;
            }
            if (literals > 0) {
                outPos = UnsafeChunkEncoderLE._copyPartialLiterals(in, inPos, out, outPos, literals);
                literals = 0;
            }
            int maxLen = Math.min(264, inEnd - inPos + 2);
            int len = UnsafeChunkEncoderLE._findMatchLength(in, ref + 3, inPos + 3, ref + maxLen);
            --off;
            if (len < 7) {
                out[outPos++] = (byte)((off >> 8) + (len << 5));
            } else {
                out[outPos++] = (byte)((off >> 8) + 224);
                out[outPos++] = (byte)(len - 7);
            }
            out[outPos++] = (byte)off;
            seen = UnsafeChunkEncoderLE._getInt(in, inPos += len);
            hashTable[this.hash((int)(seen >> 8))] = inPos++;
            hashTable[this.hash((int)seen)] = inPos++;
        }
        return UnsafeChunkEncoderLE._handleTail(in, inPos, inEnd + 4, out, outPos, literals);
    }

    private static final int _getInt(byte[] in, int inPos) {
        return Integer.reverseBytes(unsafe.getInt(in, BYTE_ARRAY_OFFSET + (long)inPos));
    }

    private static final int _findMatchLength(byte[] in, int ptr1, int ptr2, int maxPtr1) {
        int i2;
        if (ptr1 + 8 >= maxPtr1) {
            return UnsafeChunkEncoderLE._findTailMatchLength(in, ptr1, ptr2, maxPtr1);
        }
        int i1 = unsafe.getInt(in, BYTE_ARRAY_OFFSET + (long)ptr1);
        if (i1 != (i2 = unsafe.getInt(in, BYTE_ARRAY_OFFSET + (long)ptr2))) {
            return 1 + UnsafeChunkEncoderLE._leadingBytes(i1, i2);
        }
        i1 = unsafe.getInt(in, BYTE_ARRAY_OFFSET + (long)(ptr1 += 4));
        if (i1 != (i2 = unsafe.getInt(in, BYTE_ARRAY_OFFSET + (long)(ptr2 += 4)))) {
            return 5 + UnsafeChunkEncoderLE._leadingBytes(i1, i2);
        }
        return UnsafeChunkEncoderLE._findLongMatchLength(in, ptr1 + 4, ptr2 + 4, maxPtr1);
    }

    private static final int _findLongMatchLength(byte[] in, int ptr1, int ptr2, int maxPtr1) {
        int base = ptr1 - 9;
        int longEnd = maxPtr1 - 8;
        while (ptr1 <= longEnd) {
            long l2;
            long l1 = unsafe.getLong(in, BYTE_ARRAY_OFFSET + (long)ptr1);
            if (l1 != (l2 = unsafe.getLong(in, BYTE_ARRAY_OFFSET + (long)ptr2))) {
                return ptr1 - base + (Long.numberOfTrailingZeros(l1 ^ l2) >> 3);
            }
            ptr1 += 8;
            ptr2 += 8;
        }
        while (ptr1 < maxPtr1 && in[ptr1] == in[ptr2]) {
            ++ptr1;
            ++ptr2;
        }
        return ptr1 - base;
    }

    private static final int _leadingBytes(int i1, int i2) {
        return Long.numberOfTrailingZeros(i1 ^ i2) >> 3;
    }
}

