/*
 * Decompiled with CFR 0.152.
 */
package com.ning.compress.lzf.impl;

import com.ning.compress.lzf.LZFChunk;
import com.ning.compress.lzf.impl.UnsafeChunkEncoder;
import com.ning.compress.lzf.impl.UnsafeChunkEncoders;

public class UnsafeLZFEncoder {
    public static final int MAX_CHUNK_RESULT_SIZE = 133191;

    private UnsafeLZFEncoder() {
    }

    public static int estimateMaxWorkspaceSize(int inputSize) {
        if (inputSize <= 65535) {
            return 7 + inputSize + (inputSize >> 5) + (inputSize >> 6);
        }
        if ((inputSize -= 65535) <= 65535) {
            return 133191 + inputSize + 7;
        }
        int chunkCount = 1 + (inputSize + 65534) / 65535;
        return 133191 + chunkCount * 65542;
    }

    public static byte[] encode(byte[] data) {
        return UnsafeLZFEncoder.encode(data, data.length);
    }

    public static byte[] encode(byte[] data, int length) {
        return UnsafeLZFEncoder.encode(data, 0, length);
    }

    public static byte[] encode(byte[] data, int offset, int length) {
        UnsafeChunkEncoder enc = UnsafeChunkEncoders.createEncoder(length);
        byte[] result = UnsafeLZFEncoder.encode(enc, data, offset, length);
        enc.close();
        return result;
    }

    public static byte[] encode(UnsafeChunkEncoder enc, byte[] data, int length) {
        return UnsafeLZFEncoder.encode(enc, data, 0, length);
    }

    public static byte[] encode(UnsafeChunkEncoder enc, byte[] data, int offset, int length) {
        int left = length;
        int chunkLen = Math.min(65535, left);
        LZFChunk first = enc.encodeChunk(data, offset, chunkLen);
        if ((left -= chunkLen) < 1) {
            return first.getData();
        }
        int resultBytes = first.length();
        offset += chunkLen;
        LZFChunk last = first;
        do {
            chunkLen = Math.min(left, 65535);
            LZFChunk chunk = enc.encodeChunk(data, offset, chunkLen);
            offset += chunkLen;
            resultBytes += chunk.length();
            last.setNext(chunk);
            last = chunk;
        } while ((left -= chunkLen) > 0);
        byte[] result = new byte[resultBytes];
        int ptr = 0;
        while (first != null) {
            ptr = first.copyTo(result, ptr);
            first = first.next();
        }
        return result;
    }

    public static int appendEncoded(byte[] input, int inputPtr, int inputLength, byte[] outputBuffer, int outputPtr) {
        return UnsafeLZFEncoder.appendEncoded(UnsafeChunkEncoders.createNonAllocatingEncoder(inputLength), input, inputPtr, inputLength, outputBuffer, outputPtr);
    }

    public static int appendEncoded(UnsafeChunkEncoder enc, byte[] input, int inputPtr, int inputLength, byte[] outputBuffer, int outputPtr) {
        int left = inputLength;
        int chunkLen = Math.min(65535, left);
        outputPtr = enc.appendEncodedChunk(input, inputPtr, chunkLen, outputBuffer, outputPtr);
        if ((left -= chunkLen) < 1) {
            return outputPtr;
        }
        inputPtr += chunkLen;
        do {
            chunkLen = Math.min(left, 65535);
            outputPtr = enc.appendEncodedChunk(input, inputPtr, chunkLen, outputBuffer, outputPtr);
            inputPtr += chunkLen;
        } while ((left -= chunkLen) > 0);
        return outputPtr;
    }
}

