/*
 * Decompiled with CFR 0.152.
 */
package com.ning.compress.lzf.util;

import com.ning.compress.BufferRecycler;
import com.ning.compress.lzf.ChunkEncoder;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LZFFileOutputStream
extends FileOutputStream {
    private static final int OUTPUT_BUFFER_SIZE = 65535;
    private final ChunkEncoder _encoder = new ChunkEncoder(65535);
    private final BufferRecycler _recycler = BufferRecycler.instance();
    protected byte[] _outputBuffer = this._recycler.allocOutputBuffer(65535);
    protected int _position = 0;
    protected boolean _cfgFinishBlockOnFlush = true;
    protected boolean _outputStreamClosed;
    private final Wrapper _wrapper = new Wrapper();

    public LZFFileOutputStream(File file) throws FileNotFoundException {
        super(file);
    }

    public LZFFileOutputStream(File file, boolean append) throws FileNotFoundException {
        super(file, append);
    }

    public LZFFileOutputStream(FileDescriptor fdObj) {
        super(fdObj);
    }

    public LZFFileOutputStream(String name) throws FileNotFoundException {
        super(name);
    }

    public LZFFileOutputStream(String name, boolean append) throws FileNotFoundException {
        super(name, append);
    }

    public LZFFileOutputStream setFinishBlockOnFlush(boolean b) {
        this._cfgFinishBlockOnFlush = b;
        return this;
    }

    public void close() throws IOException {
        if (!this._outputStreamClosed) {
            if (this._position > 0) {
                this.writeCompressedBlock();
            }
            super.flush();
            this._encoder.close();
            byte[] buf = this._outputBuffer;
            if (buf != null) {
                this._outputBuffer = null;
                this._recycler.releaseOutputBuffer(buf);
            }
            this._outputStreamClosed = true;
            super.close();
        }
    }

    public void flush() throws IOException {
        this.checkNotClosed();
        if (this._cfgFinishBlockOnFlush && this._position > 0) {
            this.writeCompressedBlock();
        }
        super.flush();
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        this.checkNotClosed();
        int BUFFER_LEN = this._outputBuffer.length;
        int free = BUFFER_LEN - this._position;
        if (free >= length) {
            System.arraycopy(buffer, offset, this._outputBuffer, this._position, length);
            this._position += length;
            return;
        }
        System.arraycopy(buffer, offset, this._outputBuffer, this._position, free);
        offset += free;
        length -= free;
        this._position += free;
        this.writeCompressedBlock();
        while (length >= BUFFER_LEN) {
            this._encoder.encodeAndWriteChunk(buffer, offset, BUFFER_LEN, this._wrapper);
            offset += BUFFER_LEN;
            length -= BUFFER_LEN;
        }
        if (length > 0) {
            System.arraycopy(buffer, offset, this._outputBuffer, 0, length);
        }
        this._position = length;
    }

    public void write(int b) throws IOException {
        this.checkNotClosed();
        if (this._position >= this._outputBuffer.length) {
            this.writeCompressedBlock();
        }
        this._outputBuffer[this._position++] = (byte)b;
    }

    public boolean getFinishBlockOnFlush() {
        return this._cfgFinishBlockOnFlush;
    }

    public LZFFileOutputStream finishBlock() throws IOException {
        this.checkNotClosed();
        if (this._position > 0) {
            this.writeCompressedBlock();
        }
        return this;
    }

    protected void writeCompressedBlock() throws IOException {
        int chunkLen;
        int left = this._position;
        this._position = 0;
        int offset = 0;
        do {
            chunkLen = Math.min(65535, left);
            this._encoder.encodeAndWriteChunk(this._outputBuffer, offset, chunkLen, this._wrapper);
            offset += chunkLen;
        } while ((left -= chunkLen) > 0);
    }

    protected void rawWrite(byte[] buffer, int offset, int length) throws IOException {
        super.write(buffer, offset, length);
    }

    protected void checkNotClosed() throws IOException {
        if (this._outputStreamClosed) {
            throw new IOException(this.getClass().getName() + " already closed");
        }
    }

    private final class Wrapper
    extends OutputStream {
        private Wrapper() {
        }

        public void write(int arg0) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void write(byte[] buffer, int offset, int length) throws IOException {
            LZFFileOutputStream.this.rawWrite(buffer, offset, length);
        }
    }
}

