/*
 * Decompiled with CFR 0.152.
 */
package com.ning.compress.lzf;

import com.ning.compress.BufferRecycler;
import com.ning.compress.lzf.LZFChunk;
import java.io.IOException;
import java.io.OutputStream;

public class ChunkEncoder {
    private static final int MIN_BLOCK_TO_COMPRESS = 16;
    private static final int MIN_HASH_SIZE = 256;
    private static final int MAX_HASH_SIZE = 16384;
    private static final int MAX_OFF = 8192;
    private static final int MAX_REF = 264;
    private final BufferRecycler _recycler;
    private int[] _hashTable;
    private final int _hashModulo;
    private byte[] _encodeBuffer;
    private byte[] _headerBuffer;

    public ChunkEncoder(int totalLength) {
        int largestChunkLen = Math.max(totalLength, 65535);
        int suggestedHashLen = ChunkEncoder.calcHashLen(largestChunkLen);
        this._recycler = BufferRecycler.instance();
        this._hashTable = this._recycler.allocEncodingHash(suggestedHashLen);
        this._hashModulo = this._hashTable.length - 1;
        int bufferLen = largestChunkLen + (largestChunkLen + 31 >> 5);
        this._encodeBuffer = this._recycler.allocEncodingBuffer(bufferLen);
    }

    public void close() {
        int[] ibuf;
        byte[] buf = this._encodeBuffer;
        if (buf != null) {
            this._encodeBuffer = null;
            this._recycler.releaseEncodeBuffer(buf);
        }
        if ((ibuf = this._hashTable) != null) {
            this._hashTable = null;
            this._recycler.releaseEncodingHash(ibuf);
        }
    }

    public LZFChunk encodeChunk(byte[] data, int offset, int len) {
        int compLen;
        if (len >= 16 && (compLen = this.tryCompress(data, offset, offset + len, this._encodeBuffer, 0)) < len - 2) {
            return LZFChunk.createCompressed(len, this._encodeBuffer, 0, compLen);
        }
        return LZFChunk.createNonCompressed(data, offset, len);
    }

    public void encodeAndWriteChunk(byte[] data, int offset, int len, OutputStream out) throws IOException {
        int compLen;
        byte[] headerBuf = this._headerBuffer;
        if (headerBuf == null) {
            this._headerBuffer = headerBuf = new byte[7];
        }
        if (len >= 16 && (compLen = this.tryCompress(data, offset, offset + len, this._encodeBuffer, 0)) < len - 2) {
            LZFChunk.writeCompressedHeader(len, compLen, out, headerBuf);
            out.write(this._encodeBuffer, 0, compLen);
            return;
        }
        LZFChunk.writeNonCompressedHeader(len, out, headerBuf);
        out.write(data, offset, len);
    }

    private static int calcHashLen(int chunkSize) {
        int hashLen;
        if ((chunkSize += chunkSize) >= 16384) {
            return 16384;
        }
        for (hashLen = 256; hashLen < chunkSize; hashLen += hashLen) {
        }
        return hashLen;
    }

    private final int first(byte[] in, int inPos) {
        return (in[inPos] << 8) + (in[inPos + 1] & 0xFF);
    }

    private final int hash(int h) {
        return h * 57321 >> 9 & this._hashModulo;
    }

    private int tryCompress(byte[] in, int inPos, int inEnd, byte[] out, int outPos) {
        int[] hashTable = this._hashTable;
        ++outPos;
        int seen = this.first(in, 0);
        int literals = 0;
        inEnd -= 4;
        int firstPos = inPos;
        while (inPos < inEnd) {
            int len;
            byte p2 = in[inPos + 2];
            seen = (seen << 8) + (p2 & 0xFF);
            int off = this.hash(seen);
            int ref = hashTable[off];
            hashTable[off] = inPos;
            if (ref >= inPos || ref < firstPos || (off = inPos - ref) > 8192 || in[ref + 2] != p2 || in[ref + 1] != (byte)(seen >> 8) || in[ref] != (byte)(seen >> 16)) {
                out[outPos++] = in[inPos++];
                if (++literals != 32) continue;
                out[outPos - 33] = 31;
                literals = 0;
                ++outPos;
                continue;
            }
            int maxLen = inEnd - inPos + 2;
            if (maxLen > 264) {
                maxLen = 264;
            }
            if (literals == 0) {
                --outPos;
            } else {
                out[outPos - literals - 1] = (byte)(literals - 1);
                literals = 0;
            }
            for (len = 3; len < maxLen && in[ref + len] == in[inPos + len]; ++len) {
            }
            --off;
            if ((len -= 2) < 7) {
                out[outPos++] = (byte)((off >> 8) + (len << 5));
            } else {
                out[outPos++] = (byte)((off >> 8) + 224);
                out[outPos++] = (byte)(len - 7);
            }
            out[outPos++] = (byte)off;
            ++outPos;
            seen = this.first(in, inPos += len);
            seen = (seen << 8) + (in[inPos + 2] & 0xFF);
            hashTable[this.hash((int)seen)] = inPos++;
            seen = (seen << 8) + (in[inPos + 2] & 0xFF);
            hashTable[this.hash((int)seen)] = inPos++;
        }
        return this.handleTail(in, inPos, inEnd + 4, out, outPos, literals);
    }

    private final int handleTail(byte[] in, int inPos, int inEnd, byte[] out, int outPos, int literals) {
        while (inPos < inEnd) {
            out[outPos++] = in[inPos++];
            if (++literals != 32) continue;
            out[outPos - literals - 1] = (byte)(literals - 1);
            literals = 0;
            ++outPos;
        }
        out[outPos - literals - 1] = (byte)(literals - 1);
        if (literals == 0) {
            --outPos;
        }
        return outPos;
    }
}

