/*
 * Decompiled with CFR 0.152.
 */
package com.ning.compress.lzf.util;

import com.ning.compress.lzf.BufferRecycler;
import com.ning.compress.lzf.LZFDecoder;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class LZFFileInputStream
extends FileInputStream {
    private final BufferRecycler _recycler = BufferRecycler.instance();
    protected boolean _inputStreamClosed = false;
    protected boolean _cfgFullReads = false;
    private byte[] _inputBuffer = this._recycler.allocInputBuffer(65535);
    private byte[] _decodedBytes = this._recycler.allocDecodeBuffer(65535);
    private int _bufferPosition = 0;
    private int _bufferLength = 0;
    private final Wrapper _wrapper = new Wrapper();

    public LZFFileInputStream(File file) throws FileNotFoundException {
        super(file);
    }

    public LZFFileInputStream(FileDescriptor fdObj) {
        super(fdObj);
    }

    public LZFFileInputStream(String name) throws FileNotFoundException {
        super(name);
    }

    public void setUseFullReads(boolean b) {
        this._cfgFullReads = b;
    }

    public int available() {
        if (this._inputStreamClosed) {
            return -1;
        }
        int left = this._bufferLength - this._bufferPosition;
        return left <= 0 ? 0 : left;
    }

    public void close() throws IOException {
        this._bufferLength = 0;
        this._bufferPosition = 0;
        byte[] buf = this._inputBuffer;
        if (buf != null) {
            this._inputBuffer = null;
            this._recycler.releaseInputBuffer(buf);
        }
        if ((buf = this._decodedBytes) != null) {
            this._decodedBytes = null;
            this._recycler.releaseDecodeBuffer(buf);
        }
        if (!this._inputStreamClosed) {
            this._inputStreamClosed = true;
            super.close();
        }
    }

    public int read() throws IOException {
        if (!this.readyBuffer()) {
            return -1;
        }
        return this._decodedBytes[this._bufferPosition++] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (length < 1) {
            this.checkNotClosed();
            return 0;
        }
        if (!this.readyBuffer()) {
            return -1;
        }
        int chunkLength = Math.min(this._bufferLength - this._bufferPosition, length);
        System.arraycopy(this._decodedBytes, this._bufferPosition, buffer, offset, chunkLength);
        this._bufferPosition += chunkLength;
        if (chunkLength == length || !this._cfgFullReads) {
            return chunkLength;
        }
        int totalRead = chunkLength;
        do {
            offset += chunkLength;
            if (!this.readyBuffer()) break;
            chunkLength = Math.min(this._bufferLength - this._bufferPosition, length - totalRead);
            System.arraycopy(this._decodedBytes, this._bufferPosition, buffer, offset, chunkLength);
            this._bufferPosition += chunkLength;
        } while ((totalRead += chunkLength) < length);
        return totalRead;
    }

    public long skip(long n) throws IOException {
        if (!this.readyBuffer()) {
            return -1L;
        }
        long left = this._bufferLength - this._bufferPosition;
        if (left > n) {
            left = (int)n;
        }
        this._bufferPosition = (int)((long)this._bufferPosition + left);
        return left;
    }

    protected boolean readyBuffer() throws IOException {
        this.checkNotClosed();
        if (this._bufferPosition < this._bufferLength) {
            return true;
        }
        this._bufferLength = LZFDecoder.decompressChunk(this._wrapper, this._inputBuffer, this._decodedBytes);
        if (this._bufferLength < 0) {
            return false;
        }
        this._bufferPosition = 0;
        return this._bufferPosition < this._bufferLength;
    }

    protected final int readRaw(byte[] buffer, int offset, int length) throws IOException {
        return super.read(buffer, offset, length);
    }

    protected void checkNotClosed() throws IOException {
        if (this._inputStreamClosed) {
            throw new IOException(this.getClass().getName() + " already closed");
        }
    }

    private final class Wrapper
    extends InputStream {
        private Wrapper() {
        }

        public int read() throws IOException {
            throw new UnsupportedOperationException();
        }

        public int read(byte[] buffer, int offset, int length) throws IOException {
            return LZFFileInputStream.this.readRaw(buffer, offset, length);
        }
    }
}

