/*
 * Decompiled with CFR 0.152.
 */
package com.ning.compress.lzf;

import com.ning.compress.lzf.BufferRecycler;
import com.ning.compress.lzf.LZFDecoder;
import java.io.IOException;
import java.io.InputStream;

public class LZFInputStream
extends InputStream {
    private final BufferRecycler _recycler = BufferRecycler.instance();
    protected final InputStream _inputStream;
    protected boolean _inputStreamClosed;
    protected boolean _cfgFullReads = false;
    private byte[] _inputBuffer;
    private byte[] _decodedBytes;
    private int _bufferPosition = 0;
    private int _bufferLength = 0;

    public LZFInputStream(InputStream inputStream) throws IOException {
        this(inputStream, false);
    }

    public LZFInputStream(InputStream in, boolean fullReads) throws IOException {
        this._inputStream = in;
        this._inputStreamClosed = false;
        this._cfgFullReads = fullReads;
        this._inputBuffer = this._recycler.allocInputBuffer(65535);
        this._decodedBytes = this._recycler.allocDecodeBuffer(65535);
    }

    public void setUseFullReads(boolean b) {
        this._cfgFullReads = b;
    }

    public int available() {
        if (this._inputStreamClosed) {
            return -1;
        }
        int left = this._bufferLength - this._bufferPosition;
        return left <= 0 ? 0 : left;
    }

    public int read() throws IOException {
        if (!this.readyBuffer()) {
            return -1;
        }
        return this._decodedBytes[this._bufferPosition++] & 0xFF;
    }

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (length < 1) {
            this.checkNotClosed();
            return 0;
        }
        if (!this.readyBuffer()) {
            return -1;
        }
        int chunkLength = Math.min(this._bufferLength - this._bufferPosition, length);
        System.arraycopy(this._decodedBytes, this._bufferPosition, buffer, offset, chunkLength);
        this._bufferPosition += chunkLength;
        if (chunkLength == length || !this._cfgFullReads) {
            return chunkLength;
        }
        int totalRead = chunkLength;
        do {
            offset += chunkLength;
            if (!this.readyBuffer()) break;
            chunkLength = Math.min(this._bufferLength - this._bufferPosition, length - totalRead);
            System.arraycopy(this._decodedBytes, this._bufferPosition, buffer, offset, chunkLength);
            this._bufferPosition += chunkLength;
        } while ((totalRead += chunkLength) < length);
        return totalRead;
    }

    public void close() throws IOException {
        this._bufferLength = 0;
        this._bufferPosition = 0;
        byte[] buf = this._inputBuffer;
        if (buf != null) {
            this._inputBuffer = null;
            this._recycler.releaseInputBuffer(buf);
        }
        if ((buf = this._decodedBytes) != null) {
            this._decodedBytes = null;
            this._recycler.releaseDecodeBuffer(buf);
        }
        if (!this._inputStreamClosed) {
            this._inputStreamClosed = true;
            this._inputStream.close();
        }
    }

    public long skip(long n) throws IOException {
        if (!this.readyBuffer()) {
            return -1L;
        }
        long left = this._bufferLength - this._bufferPosition;
        if (left > n) {
            left = (int)n;
        }
        this._bufferPosition = (int)((long)this._bufferPosition + left);
        return left;
    }

    public InputStream getUnderlyingInputStream() {
        return this._inputStream;
    }

    public void discardBuffered() {
        this._bufferLength = 0;
        this._bufferPosition = 0;
    }

    protected boolean readyBuffer() throws IOException {
        this.checkNotClosed();
        if (this._bufferPosition < this._bufferLength) {
            return true;
        }
        this._bufferLength = LZFDecoder.decompressChunk(this._inputStream, this._inputBuffer, this._decodedBytes);
        if (this._bufferLength < 0) {
            return false;
        }
        this._bufferPosition = 0;
        return this._bufferPosition < this._bufferLength;
    }

    protected void checkNotClosed() throws IOException {
        if (this._inputStreamClosed) {
            throw new IOException(this.getClass().getName() + " already closed");
        }
    }
}

