/*
 * Decompiled with CFR 0.152.
 */
package com.ning.compress.lzf;

import com.ning.compress.lzf.LZFEncoder;
import java.io.IOException;
import java.io.OutputStream;

public class LZFOutputStream
extends OutputStream {
    private static int OUTPUT_BUFFER_SIZE = 65535;
    protected final OutputStream outputStream;
    protected byte[] outputBuffer = new byte[OUTPUT_BUFFER_SIZE];
    protected int position = 0;

    public LZFOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void write(int singleByte) throws IOException {
        if (this.position >= this.outputBuffer.length) {
            this.writeCompressedBlock();
        }
        this.outputBuffer[this.position++] = (byte)singleByte;
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        int inputCursor = offset;
        int remainingBytes = length;
        while (remainingBytes > 0) {
            if (this.position >= this.outputBuffer.length) {
                this.writeCompressedBlock();
            }
            int chunkLength = remainingBytes > this.outputBuffer.length - this.position ? this.outputBuffer.length - this.position : remainingBytes;
            System.arraycopy(buffer, inputCursor, this.outputBuffer, this.position, chunkLength);
            this.position += chunkLength;
            remainingBytes -= chunkLength;
            inputCursor += chunkLength;
        }
    }

    public void flush() throws IOException {
        this.writeCompressedBlock();
        this.outputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.flush();
        }
        finally {
            this.outputStream.close();
        }
    }

    private void writeCompressedBlock() throws IOException {
        if (this.position > 0) {
            byte[] compressedBytes = LZFEncoder.encode(this.outputBuffer, this.position);
            this.outputStream.write(compressedBytes);
            this.position = 0;
        }
    }
}

