/*
 * Decompiled with CFR 0.152.
 */
package com.ning.compress.lzf;

import com.ning.compress.lzf.LZFDecoder;
import java.io.IOException;
import java.io.InputStream;

public class LZFInputStream
extends InputStream {
    public static int EOF_FLAG = -1;
    protected final InputStream inputStream;
    protected boolean cfgFullReads = false;
    private final byte[] compressedBytes = new byte[65535];
    private final byte[] uncompressedBytes = new byte[65535];
    private int bufferPosition = 0;
    private int bufferLength = 0;

    public LZFInputStream(InputStream inputStream) throws IOException {
        this(inputStream, false);
    }

    public LZFInputStream(InputStream inputStream, boolean fullReads) throws IOException {
        this.inputStream = inputStream;
        this.cfgFullReads = fullReads;
    }

    public int read() throws IOException {
        int returnValue = EOF_FLAG;
        this.readyBuffer();
        if (this.bufferPosition < this.bufferLength) {
            returnValue = this.uncompressedBytes[this.bufferPosition++] & 0xFF;
        }
        return returnValue;
    }

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (length < 1) {
            return 0;
        }
        this.readyBuffer();
        if (this.bufferLength == -1) {
            return -1;
        }
        int chunkLength = Math.min(this.bufferLength - this.bufferPosition, length);
        System.arraycopy(this.uncompressedBytes, this.bufferPosition, buffer, offset, chunkLength);
        this.bufferPosition += chunkLength;
        if (chunkLength == length || !this.cfgFullReads) {
            return chunkLength;
        }
        int totalRead = chunkLength;
        do {
            offset += chunkLength;
            this.readyBuffer();
            if (this.bufferLength == -1) break;
            chunkLength = Math.min(this.bufferLength - this.bufferPosition, length - totalRead);
            System.arraycopy(this.uncompressedBytes, this.bufferPosition, buffer, offset, chunkLength);
            this.bufferPosition += chunkLength;
        } while ((totalRead += chunkLength) < length);
        return totalRead;
    }

    public void close() throws IOException {
        this.bufferLength = 0;
        this.bufferPosition = 0;
        this.inputStream.close();
    }

    private final void readyBuffer() throws IOException {
        if (this.bufferPosition >= this.bufferLength) {
            this.bufferLength = LZFDecoder.decompressChunk(this.inputStream, this.compressedBytes, this.uncompressedBytes);
            this.bufferPosition = 0;
        }
    }
}

