/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.cookie;

import com.ning.http.client.cookie.RFC2616DateParser;
import java.text.ParsePosition;
import java.util.BitSet;
import java.util.Date;

public class CookieUtil {
    private static final BitSet VALID_COOKIE_VALUE_OCTETS = CookieUtil.validCookieValueOctets();
    private static final BitSet VALID_COOKIE_NAME_OCTETS = CookieUtil.validCookieNameOctets(VALID_COOKIE_VALUE_OCTETS);

    private static BitSet validCookieValueOctets() {
        int i;
        BitSet bits = new BitSet(8);
        bits.set(33);
        for (i = 35; i <= 43; ++i) {
            bits.set(i);
        }
        for (i = 45; i <= 58; ++i) {
            bits.set(i);
        }
        for (i = 60; i <= 91; ++i) {
            bits.set(i);
        }
        for (i = 93; i <= 126; ++i) {
            bits.set(i);
        }
        return bits;
    }

    private static BitSet validCookieNameOctets(BitSet validCookieValueOctets) {
        BitSet bits = new BitSet(8);
        for (int i = 32; i < 127; ++i) {
            bits.set(i);
        }
        bits.set(40, false);
        bits.set(41, false);
        bits.set(60, false);
        bits.set(62, false);
        bits.set(64, false);
        bits.set(44, false);
        bits.set(59, false);
        bits.set(58, false);
        bits.set(92, false);
        bits.set(34, false);
        bits.set(47, false);
        bits.set(91, false);
        bits.set(93, false);
        bits.set(63, false);
        bits.set(61, false);
        bits.set(123, false);
        bits.set(125, false);
        bits.set(32, false);
        bits.set(9, false);
        return bits;
    }

    static int firstInvalidCookieNameOctet(CharSequence cs) {
        return CookieUtil.firstInvalidOctet(cs, VALID_COOKIE_NAME_OCTETS);
    }

    static int firstInvalidCookieValueOctet(CharSequence cs) {
        return CookieUtil.firstInvalidOctet(cs, VALID_COOKIE_VALUE_OCTETS);
    }

    static int firstInvalidOctet(CharSequence cs, BitSet bits) {
        for (int i = 0; i < cs.length(); ++i) {
            char c = cs.charAt(i);
            if (bits.get(c)) continue;
            return i;
        }
        return -1;
    }

    static CharSequence unwrapValue(CharSequence cs) {
        int len = cs.length();
        if (len > 0 && cs.charAt(0) == '\"') {
            if (len >= 2 && cs.charAt(len - 1) == '\"') {
                return len == 2 ? "" : cs.subSequence(1, len - 1);
            }
            return null;
        }
        return cs;
    }

    static long computeExpiresAsMaxAge(String expires) {
        Date expiresDate;
        if (expires != null && (expiresDate = RFC2616DateParser.get().parse(expires, new ParsePosition(0))) != null) {
            long maxAgeMillis = expiresDate.getTime() - System.currentTimeMillis();
            return maxAgeMillis / 1000L + (long)(maxAgeMillis % 1000L != 0L ? 1 : 0);
        }
        return Long.MIN_VALUE;
    }

    private CookieUtil() {
    }
}

