/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client;

import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.util.SslUtils;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public interface SSLEngineFactory {
    public SSLEngine newSSLEngine(String var1, int var2) throws GeneralSecurityException;

    public static class DefaultSSLEngineFactory
    implements SSLEngineFactory {
        private final AsyncHttpClientConfig config;

        public DefaultSSLEngineFactory(AsyncHttpClientConfig config) {
            this.config = config;
        }

        @Override
        public SSLEngine newSSLEngine(String peerHost, int peerPort) throws GeneralSecurityException {
            SSLContext sslContext = this.config.getSSLContext();
            if (sslContext == null) {
                sslContext = SslUtils.getInstance().getSSLContext(this.config.isAcceptAnyCertificate());
            }
            SSLEngine sslEngine = sslContext.createSSLEngine(peerHost, peerPort);
            if (!this.config.isAcceptAnyCertificate()) {
                SSLParameters params = sslEngine.getSSLParameters();
                params.setEndpointIdentificationAlgorithm("HTTPS");
                sslEngine.setSSLParameters(params);
            }
            sslEngine.setUseClientMode(true);
            if (this.config.getEnabledProtocols() != null) {
                sslEngine.setEnabledProtocols(this.config.getEnabledProtocols());
            }
            if (this.config.getEnabledCipherSuites() != null) {
                sslEngine.setEnabledCipherSuites(this.config.getEnabledCipherSuites());
            }
            return sslEngine;
        }
    }
}

