/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty.util;

import com.ning.http.client.uri.UriComponents;
import com.ning.http.util.MiscUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.netty.handler.codec.http.HttpHeaders;

public final class HttpUtils {
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final String WEBSOCKET = "ws";
    public static final String WEBSOCKET_SSL = "wss";

    private HttpUtils() {
    }

    public static boolean isNTLM(List<String> auth) {
        return MiscUtils.isNonEmpty(auth) && auth.get(0).startsWith("NTLM");
    }

    public static List<String> getNettyHeaderValuesByCaseInsensitiveName(HttpHeaders headers, String name) {
        ArrayList<String> l = new ArrayList<String>();
        for (Map.Entry e : headers) {
            if (!((String)e.getKey()).equalsIgnoreCase(name)) continue;
            l.add(((String)e.getValue()).trim());
        }
        return l;
    }

    public static boolean isWebSocket(String scheme) {
        return WEBSOCKET.equalsIgnoreCase(scheme) || WEBSOCKET_SSL.equalsIgnoreCase(scheme);
    }

    public static boolean isSecure(String scheme) {
        return HTTPS.equalsIgnoreCase(scheme) || WEBSOCKET_SSL.equalsIgnoreCase(scheme);
    }

    public static boolean isSecure(UriComponents uri) {
        return HttpUtils.isSecure(uri.getScheme());
    }
}

